/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.util;

import de.fzj.unicore.persist.Persist;
import de.fzj.unicore.persist.PersistenceFactory;
import de.fzj.unicore.persist.PersistenceProperties;
import de.fzj.unicore.persist.impl.PersistenceDescriptor;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.Set;

public class Convert {
    private final Persist input;
    private final Persist output;

    public Convert(Properties inputConfig, Properties outputConfig) throws Exception {
        Class<?> inClass = Class.forName((String)inputConfig.remove("class"));
        Class<?> inPersistImpl = Class.forName(inputConfig.getProperty("persistence.class"));
        String inTableName = (String)inputConfig.remove("tableName");
        PersistenceDescriptor pdIn = PersistenceDescriptor.get(inClass);
        if (inTableName != null) {
            pdIn.setTableName(inTableName);
        }
        this.input = PersistenceFactory.get(new PersistenceProperties(inputConfig)).configurePersist(inClass, inPersistImpl, pdIn);
        Class<?> outClass = Class.forName((String)outputConfig.remove("class"));
        Class<?> outPersistImpl = Class.forName(outputConfig.getProperty("persistence.class"));
        String outTableName = (String)outputConfig.remove("tableName");
        PersistenceDescriptor pdOut = PersistenceDescriptor.get(outClass);
        if (outTableName != null) {
            pdOut.setTableName(outTableName);
        }
        this.output = PersistenceFactory.get(new PersistenceProperties(outputConfig)).configurePersist(outClass, outPersistImpl, pdOut);
    }

    public void convert() throws Exception {
        int errors = 0;
        Set<String> ids = this.input.getIDs();
        System.out.print("Will convert " + ids.size() + " entries.");
        for (String s : ids) {
            System.out.print("Converting " + s + " ...");
            try {
                Object in = this.input.getForUpdate(s);
                this.output.write(in);
                System.out.println("... OK");
            }
            catch (Exception ex) {
                System.out.println("... error: " + ex.getMessage());
                ++errors;
            }
        }
        System.out.println("Done, " + errors + " errors occured.");
    }

    public void shutDown() throws Exception {
        this.output.shutdown();
        this.input.shutdown();
    }

    public Persist<?> getInput() {
        return this.input;
    }

    public Persist<?> getOutput() {
        return this.output;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("*** Convert utility *** ");
        Properties inputConfig = new Properties();
        inputConfig.load(new FileInputStream(args[0]));
        Properties outputConfig = new Properties();
        outputConfig.load(new FileInputStream(args[1]));
        Convert converter = new Convert(inputConfig, outputConfig);
        converter.convert();
        converter.shutDown();
    }
}

