/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.Version;

public class LuceneIndexer {
    private static final Logger LOG = Logger.getLogger((String)("unicore.persistence." + LuceneIndexer.class.getSimpleName()));
    public static final String CONTENT_KEY = "contents";
    public static final String RESOURCE_NAME_KEY = "resourceName";
    private static final String SEARCH_KEY = "contents";
    private final String dataDirectory;
    private final Directory directory;
    private static final Version VER = Version.LUCENE_34;
    private final QueryParser parser = new QueryParser(VER, "contents", (Analyzer)new StandardAnalyzer(VER));
    private final IndexWriter indexWriter;
    private static final Map<String, LuceneIndexer> indexers = new HashMap<String, LuceneIndexer>();

    public static synchronized LuceneIndexer get(String id, String indexDir) {
        LuceneIndexer indexer = indexers.get(id);
        if (indexer == null) {
            indexer = new LuceneIndexer(indexDir + id);
            indexers.put(id, indexer);
        }
        return indexer;
    }

    LuceneIndexer(String indexLocation) {
        this.dataDirectory = indexLocation;
        try {
            this.initalizeDataDirectory();
            this.directory = new NIOFSDirectory(new File(this.dataDirectory));
            this.indexWriter = new IndexWriter(this.directory, new IndexWriterConfig(VER, (Analyzer)new StandardAnalyzer(VER)));
            this.initializeIndex();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(String.format("Unable to initialize Lucene index in: %s", this.dataDirectory), ex);
        }
    }

    public void store(String resourceName, Map<String, String> metadata, String contents) throws IOException {
        Document document = LuceneIndexer.createMetadataDocument(metadata, resourceName, contents);
        this.indexWriter.deleteDocuments(new Term(RESOURCE_NAME_KEY, resourceName));
        this.indexWriter.addDocument(document);
    }

    public void remove(String resourceName) throws IOException {
        this.indexWriter.deleteDocuments(new Term(RESOURCE_NAME_KEY, resourceName));
    }

    public void update(String resourceName, Map<String, String> metadata, String contents) throws IOException {
        Map<String, String> mergeMetadata;
        Document doc = this.getDocument(resourceName);
        if (doc != null) {
            Map<String, String> oldMetadata = LuceneIndexer.extractMetadataFromDocument(doc);
            mergeMetadata = this.mergeMetadata(oldMetadata, metadata);
        } else {
            mergeMetadata = metadata;
        }
        this.store(resourceName, mergeMetadata, contents);
    }

    public List<String> search(String queryString, int maximalHits) throws IOException {
        IndexSearcher searcher = new IndexSearcher(this.directory);
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Query query = this.parser.parse(queryString);
            TopDocs results = searcher.search(query, maximalHits);
            for (ScoreDoc scoreDoc : results.scoreDocs) {
                String res = searcher.doc(scoreDoc.doc).get(RESOURCE_NAME_KEY);
                ret.add(res);
            }
        }
        catch (ParseException pe) {
            throw new IOException(pe);
        }
        finally {
            searcher.close();
        }
        return ret;
    }

    public List<String> search(String[] queryStrings, int numberOfrecords) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String queryString : queryStrings) {
            List<String> partialResult = this.search(queryString, numberOfrecords);
            ret.addAll(partialResult);
        }
        return ret;
    }

    public void commit() throws IOException {
        this.indexWriter.commit();
    }

    public void optimizeIndex() throws IOException {
        this.indexWriter.commit();
        this.indexWriter.optimize();
    }

    public void deleteAll() throws IOException {
        this.indexWriter.deleteAll();
    }

    protected Document getDocument(String resourceName) throws IOException {
        IndexSearcher searcher = new IndexSearcher(this.directory);
        TermQuery query = new TermQuery(new Term(RESOURCE_NAME_KEY, resourceName));
        TopDocs result = searcher.search((Query)query, 1);
        if (result.scoreDocs.length == 0) {
            return null;
        }
        Document document = searcher.doc(result.scoreDocs[0].doc);
        searcher.close();
        return document;
    }

    protected void printStatus() throws IOException {
        StringBuilder builder = new StringBuilder("Lucene status: ");
        builder.append("\nDirectory: ").append(this.dataDirectory);
        IndexReader index = this.getIndexReader();
        builder.append("\nNumber of indexed documents: ").append(index.numDocs());
        builder.append("\nIs index optimized: ").append(index.isOptimized());
        builder.append("\n");
        index.close();
        LOG.info((Object)builder.toString());
    }

    protected int getNumberOfDocuments() throws IOException {
        return this.indexWriter.numDocs();
    }

    private void initalizeDataDirectory() throws IOException {
        File chkDir = new File(this.dataDirectory);
        boolean mkdirs = true;
        if (!chkDir.exists()) {
            mkdirs = chkDir.mkdirs();
        }
        if (!mkdirs || !chkDir.isDirectory()) {
            throw new IOException(String.format("Unable to create/find: %s Lucene index directory", this.dataDirectory));
        }
    }

    private void initializeIndex() throws IOException {
        this.indexWriter.commit();
        LOG.info((Object)String.format("Lucene index initialized in: %s", this.dataDirectory));
    }

    private IndexReader getIndexReader() throws IOException {
        return IndexReader.open((Directory)this.directory);
    }

    protected static Map<String, String> extractMetadataFromDocument(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Document for metadata extraction cannot be null");
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Fieldable object : document.getFields()) {
            Field field = (Field)object;
            String name = field.name();
            String value = document.get(name);
            ret.put(name, value);
        }
        return ret;
    }

    protected static Document createMetadataDocument(Map<String, String> metadata, String resource, String contents) {
        if (metadata == null || metadata.isEmpty()) {
            throw new IllegalArgumentException("Metadata cannot be null or empty");
        }
        if (resource == null || resource.trim().isEmpty()) {
            throw new IllegalArgumentException("Resource name cannot be null or empty");
        }
        Document doc = new Document();
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            doc.add((Fieldable)new Field(entry.getKey(), entry.getValue(), Field.Store.YES, Field.Index.ANALYZED));
        }
        doc.removeField(RESOURCE_NAME_KEY);
        doc.add((Fieldable)new Field(RESOURCE_NAME_KEY, resource, Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (contents != null && !contents.trim().isEmpty()) {
            doc.add((Fieldable)new Field("contents", contents, Field.Store.NO, Field.Index.ANALYZED));
        }
        return doc;
    }

    protected Map<String, String> mergeMetadata(Map<String, String> oldData, Map<String, String> newData) {
        if (oldData == null || newData == null) {
            throw new IllegalArgumentException("Metadata to merge cannot be null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(oldData);
        map.putAll(newData);
        return map;
    }
}

