/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.impl;

import de.fzj.unicore.persist.DataVersionException;
import de.fzj.unicore.persist.Persist;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.PersistenceFactory;
import de.fzj.unicore.persist.PersistenceProperties;
import de.fzj.unicore.persist.impl.ColumnDescriptor;
import de.fzj.unicore.persist.impl.ConnectionPool;
import de.fzj.unicore.persist.impl.CustomObjectInputStream;
import de.fzj.unicore.persist.impl.DeserialisationErrorAware;
import de.fzj.unicore.persist.impl.DeserialisationErrorHandler;
import de.fzj.unicore.persist.impl.LockSupport;
import de.fzj.unicore.persist.impl.PersistJmx;
import de.fzj.unicore.persist.impl.PersistenceDescriptor;
import de.fzj.unicore.persist.index.IndexEntryBuilder;
import de.fzj.unicore.persist.index.LuceneIndexer;
import de.fzj.unicore.persist.util.ThreadsafeErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public abstract class PersistImpl<T>
extends ConnectionPool
implements Persist<T> {
    private static final Logger logger = Logger.getLogger((String)("unicore.persistence." + PersistImpl.class.getSimpleName()));
    protected Class<T> daoClass;
    protected PersistenceDescriptor pd;
    protected PersistenceProperties config;
    private Cache cache;
    private Boolean caching = null;
    private LuceneIndexer indexer;
    private Boolean indexing = null;
    private LockSupport lockSupport;
    private long cacheHits = 0L;
    protected Boolean storeBinary = null;
    private String databaseName = null;
    private int contentVersion = 1;
    private int MAGIC_VERSION_HEADER = 77;
    private ClassLoader customClassLoader;
    private static CacheManager cacheManager;
    private static final AtomicInteger cacheCount;
    private final ThreadsafeErrorHandler errorHandler = new ThreadsafeErrorHandler();

    @Override
    public void setConfigSource(PersistenceProperties configSource) {
        this.config = configSource;
    }

    @Override
    public void setPersistenceDescriptor(PersistenceDescriptor pd) {
        this.pd = pd;
    }

    @Override
    public void init() throws PersistenceException {
        if (this.pd == null) {
            this.pd = PersistenceDescriptor.get(this.daoClass);
        }
        String table = this.pd.getTableName();
        try {
            this.initLockSupport();
            if (this.storeBinary == null) {
                this.storeBinary = this.config == null ? true : Boolean.parseBoolean(this.config.getSubkeyValue("store_data_as_binary", table));
            }
            Class.forName(this.getDriverName());
            this.initCache();
            this.initIndexer();
            this.contentVersion = this.config == null ? 1 : Integer.parseInt(this.config.getSubkeyValue("version", table));
            int maxConn = this.config == null ? 1 : Integer.parseInt(this.config.getSubkeyValue("max_connections", table));
            int timeout = this.config == null ? Integer.MAX_VALUE : Integer.parseInt(this.config.getSubkeyValue("pool_timeout", table));
            this.setupConnectionPool(this.getConnectionPoolDataSource(), maxConn, timeout, this.getDataSource());
            this.createTables();
            PersistenceFactory.registerMBean(new PersistJmx(this), table);
        }
        catch (Exception e) {
            logger.error((Object)("Error setting up persistence implementation for table <" + table + ">"), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void initLockSupport() {
        String configFile;
        boolean distributed;
        String table = this.pd.getTableName();
        boolean bl = distributed = this.config == null ? false : Boolean.parseBoolean(this.config.getSubkeyValue("cluster.enable", table));
        this.lockSupport = distributed ? ((configFile = this.config.getSubkeyValue("cluster.config", table)) != null ? new LockSupport(configFile, table) : new LockSupport(true, table)) : new LockSupport(false, table);
    }

    protected synchronized void initCache() {
        boolean cacheEnabled;
        boolean bl = cacheEnabled = this.config == null ? true : Boolean.parseBoolean(this.config.getSubkeyValue("cache.enable", this.pd.getTableName()));
        if (Boolean.TRUE.equals(this.caching) || this.config != null && cacheEnabled) {
            if (cacheManager == null) {
                logger.info((Object)"Initialising caching.");
                Configuration conf = new Configuration();
                CacheConfiguration cc = new CacheConfiguration();
                conf.setUpdateCheck(false);
                conf.setDefaultCacheConfiguration(cc);
                cacheManager = new CacheManager(conf);
            }
            this.caching = Boolean.TRUE;
            String defaultCacheSize = "10";
            String cacheMaxSize = this.config != null ? this.config.getSubkeyValue("cache.maxSize", this.pd.getTableName()) : defaultCacheSize;
            String cacheName = "persistence.cache." + this.pd.getTableName() + "." + cacheCount.incrementAndGet();
            this.cache = new Cache(cacheName, Integer.parseInt(cacheMaxSize), false, false, 72000L, 72000L);
            if (cacheManager.getCache(cacheName) != null) {
                cacheManager.removeCache(cacheName);
            }
            cacheManager.addCache(this.cache);
        } else {
            this.caching = Boolean.FALSE;
        }
    }

    protected void initIndexer() {
        boolean indexEnabled;
        boolean bl = indexEnabled = this.config == null ? false : Boolean.parseBoolean(this.config.getSubkeyValue("index.enable", this.pd.getTableName()));
        if (Boolean.TRUE.equals(this.indexing) || this.config != null && indexEnabled) {
            this.indexing = Boolean.TRUE;
            String indexBaseDir = this.config != null ? this.config.getSubkeyValue("index.basedir", this.pd.getTableName()) : "/tmp";
            this.indexer = LuceneIndexer.get(this.pd.getTableName() + ".INDEX", indexBaseDir + "/");
        } else {
            this.indexing = Boolean.FALSE;
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws PersistenceException {
        this.flush();
        Statement s = null;
        Connection conn = null;
        try {
            Connection connection = conn = this.getConnection();
            synchronized (connection) {
                try {
                    String sql = this.getSQLShutdown();
                    if (sql != null) {
                        s = conn.createStatement();
                        s.execute(sql);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Shutting down: " + e.getMessage()));
                }
                finally {
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
        }
        finally {
            if (conn != null) {
                try {
                    this.disposeConnection(conn);
                    if (!conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
            }
            this.shutdownPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getIDs() throws PersistenceException {
        HashSet<String> result = new HashSet<String>();
        String sql = this.getSQLSelectAllKeys();
        Connection conn = null;
        try {
            conn = this.getConnection();
            Object object = conn;
            synchronized (object) {
                Statement s = null;
                try {
                    s = conn.createStatement();
                    ResultSet rs = s.executeQuery(sql);
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                }
                catch (Exception e) {
                    throw new PersistenceException(e);
                }
                finally {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Exception e) {
                            logger.error((Object)"", (Throwable)e);
                        }
                    }
                }
            }
            object = result;
            return object;
        }
        finally {
            this.disposeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getIDs(String column, Object value) throws PersistenceException {
        HashSet<String> result = new HashSet<String>();
        Connection conn = null;
        Connection connection = conn = this.getConnection();
        synchronized (connection) {
            Statement s = null;
            try {
                s = conn.createStatement();
                String sql = this.getSQLSelectKeys(column, value);
                ResultSet rs = s.executeQuery(sql);
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                this.disposeConnection(conn);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getRowCount(String column, Object value) throws PersistenceException {
        Connection conn;
        Connection connection = conn = this.getConnection();
        synchronized (connection) {
            Statement s = null;
            try {
                s = conn.createStatement();
                String sql = this.getSQLRowCount(column, value);
                ResultSet rs = s.executeQuery(sql);
                if (!rs.next()) return -1;
                int n = rs.getInt(1);
                return n;
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                this.disposeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getRowCount() throws PersistenceException {
        Connection conn;
        Connection connection = conn = this.getConnection();
        synchronized (connection) {
            Statement s = null;
            try {
                s = conn.createStatement();
                String sql = this.getSQLRowCount();
                ResultSet rs = s.executeQuery(sql);
                if (!rs.next()) return -1;
                int n = rs.getInt(1);
                return n;
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                this.disposeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getColumnValues(String column) throws PersistenceException {
        HashMap<String, String> result = new HashMap<String, String>();
        Statement s = null;
        Connection conn = this.getConnection();
        String select = null;
        Connection connection = conn;
        synchronized (connection) {
            try {
                select = this.getSQLSelectColumn(column);
                s = conn.createStatement();
                ResultSet rs = s.executeQuery(select);
                while (rs.next()) {
                    String key = rs.getString(1);
                    String value = rs.getString(2);
                    result.put(key, value);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error executing: " + select), (Throwable)e);
                throw new PersistenceException(e);
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                this.disposeConnection(conn);
            }
        }
        return result;
    }

    @Override
    public T getForUpdate(String id) throws PersistenceException, InterruptedException {
        try {
            return this.getForUpdate(id, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException cannotOccur) {
            throw new PersistenceException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getForUpdate(String id, long timeout, TimeUnit unit) throws PersistenceException, TimeoutException, InterruptedException {
        Lock lock = this.lockSupport.getOrCreateLock(id);
        T result = null;
        if (lock.tryLock(timeout, unit)) {
            try {
                T t = result = (T)this.read(id);
                return t;
            }
            finally {
                if (result == null) {
                    this.lockSupport.cleanup(id);
                }
            }
        }
        String msg = "Time out reached: lock for table= " + this.pd.getTableName() + " uid=<" + id + "> could not be aquired";
        throw new TimeoutException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T tryGetForUpdate(String id) throws PersistenceException {
        Lock lock = this.lockSupport.getOrCreateLock(id);
        T result = null;
        if (lock.tryLock()) {
            try {
                result = this.read(id);
            }
            finally {
                if (result == null) {
                    this.lockSupport.cleanup(id);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(String id) throws PersistenceException {
        Element element;
        T result = null;
        if (this.caching.booleanValue() && (element = this.cache.get((Serializable)((Object)id))) != null) {
            ++this.cacheHits;
            Object v = element.getObjectValue();
            SoftReference ref = (SoftReference)v;
            if (ref.get() != null) {
                try {
                    return this.copy(ref.get());
                }
                catch (Exception ex) {
                    String msg = this.makeErrorMessage(id, ex);
                    throw new PersistenceException(msg, ex);
                }
            }
        }
        Connection conn = this.getConnection();
        Statement s = null;
        Connection connection = conn;
        synchronized (connection) {
            try {
                String sql = this.getSQLRead(id);
                s = conn.createStatement();
                ResultSet rs = s.executeQuery(sql);
                while (rs.next()) {
                    result = this.storeBinary != false ? (T)this.deserialize(rs.getBinaryStream(1)) : (T)this.decode(rs.getString(1));
                    if (!this.caching.booleanValue()) continue;
                    try {
                        SoftReference<Object> entry = new SoftReference<Object>(this.copy(result));
                        this.cache.put(new Element((Object)id, entry));
                    }
                    catch (Exception cn) {}
                }
            }
            catch (DataVersionException d) {
                throw d;
            }
            catch (Exception e) {
                String msg = this.makeErrorMessage(id, e);
                throw new PersistenceException(msg, e);
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                this.disposeConnection(conn);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(T dao) throws PersistenceException, IllegalStateException {
        String id = this.pd.getID(dao);
        Lock lock = this.lockSupport.getLockIfExists(id);
        if (lock != null && !lock.tryLock()) {
            throw new IllegalStateException("No write permission has been aquired!");
        }
        try {
            if (this.caching.booleanValue()) {
                try {
                    SoftReference<T> entry = new SoftReference<T>(this.copy(dao));
                    this.cache.put(new Element((Object)this.pd.getID(dao), entry));
                }
                catch (Exception cn) {
                    // empty catch block
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[" + this.pd.getTableName() + "] Persisting <" + id + ">"));
            }
            this.doWrite(dao, id);
        }
        finally {
            if (lock != null) {
                lock.unlock();
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doWrite(T dao, String id) throws PersistenceException {
        Connection conn;
        Statement s = null;
        Statement ps = null;
        boolean isUpdate = false;
        Connection connection = conn = this.getConnection();
        synchronized (connection) {
            try {
                String exists = this.getSQLExists(id);
                s = conn.createStatement();
                if (s.executeQuery(exists).next()) {
                    isUpdate = true;
                    ps = conn.prepareStatement(this.getSQLUpdate());
                    this.parametrizePSUpdate((PreparedStatement)ps, id, dao);
                    ps.executeUpdate();
                    ps.clearParameters();
                } else {
                    ps = conn.prepareStatement(this.getSQLInsert());
                    this.parametrizePSInsert((PreparedStatement)ps, id, dao);
                    ps.executeUpdate();
                    ps.clearParameters();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new PersistenceException(e);
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                this.disposeConnection(conn);
            }
        }
        return isUpdate;
    }

    public void index(T dao) throws PersistenceException {
        if (this.indexing.booleanValue()) {
            String id = this.pd.getID(dao);
            this.doIndex(dao, id);
        }
    }

    protected void doIndex(T dao, String id) throws PersistenceException {
        try {
            IndexEntryBuilder b = this.pd.getIndexEntryBuilder();
            Map<String, String> metadata = b.getIndexEntry(dao);
            String contents = null;
            this.indexer.store(id, metadata, contents);
        }
        catch (Exception ex) {
            throw new PersistenceException(ex);
        }
    }

    @Override
    public void unlock(T dao) throws PersistenceException {
        String id = this.pd.getID(dao);
        Lock lock = this.lockSupport.getLockIfExists(id);
        if (lock != null) {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String id) throws PersistenceException {
        Connection conn;
        Statement s = null;
        if (this.caching.booleanValue()) {
            this.cache.remove((Serializable)((Object)id));
        }
        Connection connection = conn = this.getConnection();
        synchronized (connection) {
            try {
                s = conn.createStatement();
                String delete = this.getSQLDelete(id);
                s.executeUpdate(delete);
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
            finally {
                this.lockSupport.cleanup(id);
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                this.disposeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() throws PersistenceException {
        Connection conn;
        Statement s = null;
        if (this.caching.booleanValue()) {
            this.cache.removeAll();
        }
        Connection connection = conn = this.getConnection();
        synchronized (connection) {
            try {
                s = conn.createStatement();
                String delete = this.getSQLDeleteAll();
                s.executeUpdate(delete);
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
            finally {
                this.lockSupport.cleanup();
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                this.disposeConnection(conn);
            }
        }
    }

    @Override
    public void purge() {
        try {
            this.dropTables();
        }
        catch (PersistenceException pe) {
            logger.info((Object)"There was an error purging data", (Throwable)pe);
        }
    }

    @Override
    public void setDaoClass(Class<?> daoClass) {
        this.daoClass = daoClass;
    }

    public Class<T> getDaoClass() {
        return this.daoClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serialize(Object a) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(this.MAGIC_VERSION_HEADER);
        bos.write(this.contentVersion);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        Object object = a;
        synchronized (object) {
            oos.writeObject(a);
            oos.close();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Serialized size [" + this.pd.getTableName() + "] " + bos.size()));
        }
        return bos.toByteArray();
    }

    protected T deserialize(byte[] data) throws IOException, ClassNotFoundException, DataVersionException {
        return (T)this.deserializeRaw(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deserializeRaw(byte[] data) throws IOException, ClassNotFoundException, DataVersionException {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        this.checkVersion(is);
        ObjectInputStream ois = this.getObjectInputStream(is);
        try {
            Object result = ois.readObject();
            DeserialisationErrorHandler handler = this.errorHandler.getHandler();
            if (handler != null && handler.hasErrors() && result instanceof DeserialisationErrorAware) {
                ((DeserialisationErrorAware)result).setDeserialisationErrorsOccured();
            }
            Object object = result;
            return object;
        }
        finally {
            try {
                ois.close();
            }
            catch (IOException e) {
                logger.debug((Object)"", (Throwable)e);
            }
        }
    }

    protected T deserialize(InputStream dataSource) throws IOException, ClassNotFoundException, DataVersionException {
        return (T)this.deserializeRaw(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deserializeRaw(InputStream dataSource) throws IOException, ClassNotFoundException, DataVersionException {
        this.checkVersion(dataSource);
        ObjectInputStream ois = this.getObjectInputStream(dataSource);
        try {
            Object object = ois.readObject();
            return object;
        }
        finally {
            try {
                ois.close();
            }
            catch (IOException e) {
                logger.debug((Object)"", (Throwable)e);
            }
        }
    }

    private ObjectInputStream getObjectInputStream(InputStream source) throws IOException {
        return new CustomObjectInputStream(source, this.customClassLoader, this.errorHandler);
    }

    private void checkVersion(InputStream is) throws IOException, DataVersionException {
        if (this.contentVersion == -1) {
            return;
        }
        int magic = is.read();
        if (this.MAGIC_VERSION_HEADER != magic) {
            throw new DataVersionException(this.contentVersion, -1);
        }
        int ver = is.read();
        if (ver != this.contentVersion) {
            throw new DataVersionException(this.contentVersion, ver);
        }
    }

    protected T copy(T obj) throws IOException, ClassNotFoundException, DataVersionException {
        return this.deserialize(this.serialize(obj));
    }

    protected String encode(T a) throws IOException {
        return new String(Base64.encodeBase64((byte[])this.serialize(a)));
    }

    protected T decode(String base64) throws IOException, ClassNotFoundException, DataVersionException {
        return this.deserialize(Base64.decodeBase64((byte[])base64.getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTables() throws PersistenceException {
        Connection conn;
        Statement s = null;
        Connection connection = conn = this.getConnection();
        synchronized (connection) {
            try {
                s = conn.createStatement();
                for (String sql : this.getSQLCreateTables()) {
                    s.execute(sql);
                }
            }
            catch (SQLException e) {
                logger.error((Object)("SQL Exception when creating tables: " + e.getMessage()));
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                this.disposeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTables() throws PersistenceException {
        Connection conn;
        Statement s = null;
        Connection connection = conn = this.getConnection();
        synchronized (connection) {
            try {
                s = conn.createStatement();
                for (String sql : this.getSQLDropTables()) {
                    s.execute(sql);
                }
            }
            catch (Exception e) {
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                this.disposeConnection(conn);
            }
        }
    }

    public abstract List<String> getSQLCreateTables();

    public abstract String getSQLStringType();

    public List<String> getSQLDropTables() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("DROP TABLE " + this.pd.getTableName());
        return result;
    }

    public String getSQLExists(String id) {
        return "SELECT id from " + this.pd.getTableName() + " WHERE id='" + id + "'";
    }

    public String getSQLRead(String id) {
        return "SELECT data from " + this.pd.getTableName() + " WHERE id='" + id + "'";
    }

    public void parametrizePSInsert(PreparedStatement psInsert, String id, T dao) throws IOException, SQLException, InvocationTargetException, IllegalAccessException {
        psInsert.setString(1, id);
        if (this.storeBinary.booleanValue()) {
            byte[] data = this.serialize(dao);
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            psInsert.setBinaryStream(2, (InputStream)bis, data.length);
        } else {
            String base64 = this.encode(dao);
            psInsert.setString(2, base64);
        }
        if (this.pd.getColumns() != null) {
            int i = 3;
            for (ColumnDescriptor c : this.pd.getColumns()) {
                Object val = c.getMethod().invoke(dao, (Object[])null);
                psInsert.setString(i, val != null ? val.toString() : null);
                ++i;
            }
        }
    }

    public String getSQLInsert() {
        if (this.pd.getColumns() != null) {
            StringBuffer columns = new StringBuffer();
            StringBuffer columnValues = new StringBuffer();
            for (ColumnDescriptor c : this.pd.getColumns()) {
                columns.append("," + c.getColumn());
                columnValues.append(",?");
            }
            return "INSERT INTO " + this.pd.getTableName() + " (id,data" + columns.toString() + ") " + "VALUES (?,?" + columnValues.toString() + ")";
        }
        return "INSERT INTO " + this.pd.getTableName() + " (id,data) VALUES (?,?)";
    }

    public String getSQLUpdate() {
        if (this.pd.getColumns() != null) {
            StringBuffer columns = new StringBuffer();
            for (ColumnDescriptor c : this.pd.getColumns()) {
                columns.append("," + c.getColumn() + "=?");
            }
            return "UPDATE " + this.pd.getTableName() + " set data =?" + columns.toString() + "WHERE id=?";
        }
        return "UPDATE " + this.pd.getTableName() + " set data=? WHERE id=?";
    }

    public void parametrizePSUpdate(PreparedStatement psUpdate, String id, T dao) throws IOException, SQLException, InvocationTargetException, IllegalAccessException {
        if (this.storeBinary.booleanValue()) {
            byte[] bytes = this.serialize(dao);
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            psUpdate.setBinaryStream(1, (InputStream)bis, bytes.length);
        } else {
            String base64 = this.encode(dao);
            psUpdate.setString(1, base64);
        }
        int i = 2;
        if (this.pd.getColumns() != null) {
            for (ColumnDescriptor c : this.pd.getColumns()) {
                Object val = c.getMethod().invoke(dao, (Object[])null);
                psUpdate.setString(i, val != null ? val.toString() : null);
                ++i;
            }
        }
        psUpdate.setString(i, id);
    }

    public String getSQLDelete(String id) {
        return "DELETE FROM " + this.pd.getTableName() + " WHERE id='" + id + "'";
    }

    public String getSQLDeleteAll() {
        return "DELETE FROM " + this.pd.getTableName();
    }

    public String getSQLSelectAllKeys() {
        return "SELECT ID FROM " + this.pd.getTableName();
    }

    public String getSQLSelectKeys(String column, Object value) {
        return this.getSQLSelectAllKeys() + " WHERE " + column + "='" + value.toString() + "'";
    }

    public String getSQLSelectColumn(String column) {
        return "SELECT ID," + column + " FROM " + this.pd.getTableName();
    }

    public String getSQLRowCount() {
        return "SELECT COUNT(ID) FROM " + this.pd.getTableName();
    }

    public String getSQLRowCount(String column, Object value) {
        return this.getSQLRowCount() + " WHERE " + column + "='" + value.toString() + "'";
    }

    public String getSQLShutdown() {
        return null;
    }

    protected abstract String createConnString();

    protected abstract String getDriverName();

    protected abstract ConnectionPoolDataSource getConnectionPoolDataSource();

    protected abstract DataSource getDataSource();

    protected String getDatabaseName() {
        String db;
        if (this.databaseName != null) {
            return this.databaseName;
        }
        if (this.config != null && (db = this.config.getSubkeyValue("database", this.pd.getTableName())) != null) {
            return db;
        }
        return this.pd.getTableName();
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    protected String getUserName() {
        return this.config.getSubkeyValue("user", this.pd.getTableName());
    }

    protected String getPassword() {
        return this.config.getSubkeyValue("password", this.pd.getTableName());
    }

    public void setStoreBinary(boolean value) {
        this.storeBinary = value;
    }

    public int getContentVersion() {
        return this.contentVersion;
    }

    public void setContentVersion(int contentVersion) {
        this.contentVersion = contentVersion;
    }

    @Override
    public void setCaching(boolean value) {
        this.caching = value;
    }

    @Override
    public Boolean getCaching() {
        return this.caching;
    }

    public void setIndexing(boolean value) {
        this.indexing = value;
    }

    public Boolean getIndexing() {
        return this.indexing;
    }

    public ClassLoader getCustomClassLoader() {
        return this.customClassLoader;
    }

    public void setCustomClassLoader(ClassLoader customClassLoader) {
        this.customClassLoader = customClassLoader;
    }

    public LuceneIndexer getIndexer() {
        return this.indexer;
    }

    private String makeErrorMessage(String id, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error for table=").append(this.pd.getTableName());
        sb.append(" uid=").append(id).append(" because of: ");
        String message = null;
        String type = null;
        type = cause.getClass().getName();
        do {
            type = cause.getClass().getName();
            message = cause.getMessage();
        } while ((cause = cause.getCause()) != null);
        if (message != null) {
            sb.append(type).append(": ").append(message);
        } else {
            sb.append(type);
        }
        return sb.toString();
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    @Override
    public void setErrorHandler(DeserialisationErrorHandler errorHandler) {
        this.errorHandler.setHandler(errorHandler);
    }

    static {
        cacheCount = new AtomicInteger(0);
    }
}

