/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.impl;

import com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.impl.ColumnDescriptor;
import de.fzj.unicore.persist.impl.PersistImpl;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class MySQLPersist<T>
extends PersistImpl<T> {
    private static final Logger logger = Logger.getLogger((String)("unicore.persistence." + MySQLPersist.class.getSimpleName()));
    private String sqlHost;
    private String sqlPort;
    private String sqlUser;
    private String sqlPass;
    private String sqlType;

    @Override
    public List<String> getSQLCreateTables() {
        String tb = this.pd.getTableName();
        if (this.sqlType == null) {
            this.sqlType = this.config.getSubkeyValue("mysql.tabletype", tb);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer columns = new StringBuffer();
        if (this.pd.getColumns() != null) {
            for (ColumnDescriptor c : this.pd.getColumns()) {
                columns.append("," + c.getColumn() + " " + this.getSQLStringType());
            }
        }
        String type = this.storeBinary != false ? "LONGBLOB" : this.getSQLStringType();
        result.add("CREATE TABLE IF NOT EXISTS " + tb + " (id VARCHAR(255) PRIMARY KEY, data " + type + columns.toString() + ") ENGINE=" + this.sqlType);
        return result;
    }

    @Override
    public String getSQLStringType() {
        return "LONGTEXT";
    }

    @Override
    protected String createConnString() {
        String tb = this.pd.getTableName();
        if (this.sqlHost == null) {
            this.sqlHost = this.config.getSubkeyValue("host", tb);
        }
        if (this.sqlPort == null) {
            this.sqlPort = this.config.getSubkeyValue("port", tb);
        }
        String conn = "jdbc:mysql://" + this.sqlHost + ":" + this.sqlPort + "/" + this.getDatabaseName() + "?autoReconnect=true";
        logger.info((Object)("Connecting to: " + conn));
        return conn;
    }

    @Override
    protected String getDriverName() {
        String driver;
        String string = driver = this.config != null ? this.config.getSubkeyValue("driver", this.pd.getTableName()) : "com.mysql.jdbc.Driver";
        if (driver == null) {
            driver = "com.mysql.jdbc.Driver";
        }
        return driver;
    }

    @Override
    protected String getUserName() {
        if (this.sqlUser == null) {
            this.sqlUser = this.config.getSubkeyValue("user", this.pd.getTableName());
        }
        return this.sqlUser;
    }

    @Override
    protected String getPassword() {
        if (this.sqlPass == null) {
            this.sqlPass = this.config.getSubkeyValue("password", this.pd.getTableName());
        }
        return this.sqlPass;
    }

    @Override
    protected ConnectionPoolDataSource getConnectionPoolDataSource() {
        MysqlConnectionPoolDataSource ds = new MysqlConnectionPoolDataSource();
        ds.setDatabaseName(this.getDatabaseName());
        this.sqlHost = this.config == null ? "localhost" : this.config.getSubkeyValue("host", this.pd.getTableName());
        this.sqlPort = this.config == null ? "3306" : this.config.getSubkeyValue("port", this.pd.getTableName());
        ds.setPort(Integer.parseInt(this.sqlPort));
        ds.setServerName(this.sqlHost);
        ds.setUser(this.getUserName());
        ds.setPassword(this.getPassword());
        ds.setAutoReconnect(true);
        ds.setAutoReconnectForConnectionPools(true);
        ds.setAutoReconnectForPools(true);
        String conn = "jdbc:mysql://" + this.sqlHost + ":" + this.sqlPort + "/" + this.getDatabaseName() + "?autoReconnect=true";
        logger.info((Object)("Connecting to: " + conn));
        return ds;
    }

    @Override
    protected DataSource getDataSource() {
        return null;
    }

    @Override
    protected Connection getConnection() throws PersistenceException {
        Connection c = null;
        try {
            c = super.getConnection();
            ((com.mysql.jdbc.Connection)c).ping();
        }
        catch (Exception se) {
            logger.warn((Object)("Error when getting a MySQL connection: " + se.getMessage() + ", trying to reconnect."));
            try {
                this.pool.cleanupPooledConnections();
            }
            catch (Exception exception) {
                // empty catch block
            }
            c = super.getConnection();
        }
        return c;
    }
}

