/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.impl;

import de.fzj.unicore.persist.Persist;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.PersistenceProperties;
import de.fzj.unicore.persist.impl.DeserialisationErrorHandler;
import de.fzj.unicore.persist.impl.PersistenceDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class InMemory<T>
implements Persist<T> {
    private Map<String, T> map = new ConcurrentHashMap<String, T>();
    private PersistenceDescriptor pd;

    @Override
    public void init() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void setConfigSource(PersistenceProperties configSource) {
    }

    @Override
    public void setDaoClass(Class<?> daoClass) {
        this.pd = PersistenceDescriptor.get(daoClass);
    }

    @Override
    public void setPersistenceDescriptor(PersistenceDescriptor pd) {
        this.pd = pd;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Set<String> getIDs() throws PersistenceException {
        return this.map.keySet();
    }

    @Override
    public Set<String> getIDs(String column, Object value) throws PersistenceException {
        HashSet<String> res = new HashSet<String>();
        for (String s : this.map.keySet()) {
            T val = this.map.get(s);
            String cmp = this.pd.getColumnValue(column, val);
            if (!this.compare(value, cmp)) continue;
            res.add(s);
        }
        return res;
    }

    @Override
    public Map<String, String> getColumnValues(String column) throws PersistenceException {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String id : this.map.keySet()) {
            T val = this.map.get(id);
            String value = this.pd.getColumnValue(column, val);
            res.put(id, value);
        }
        return res;
    }

    @Override
    public int getRowCount(String column, Object value) throws PersistenceException {
        return this.getIDs(column, value).size();
    }

    @Override
    public int getRowCount() throws PersistenceException {
        return this.getIDs().size();
    }

    private boolean compare(Object value, String cmp) {
        if (value == null) {
            return cmp == null;
        }
        return value.equals(cmp);
    }

    @Override
    public T read(String id) throws PersistenceException {
        return this.read(id, false);
    }

    public T read(String id, boolean forceRefresh) throws PersistenceException {
        return this.map.get(id);
    }

    @Override
    public T getForUpdate(String id, long timeout, TimeUnit unit) throws PersistenceException, TimeoutException, InterruptedException {
        return this.read(id);
    }

    @Override
    public T getForUpdate(String id) throws PersistenceException, InterruptedException {
        return this.read(id);
    }

    @Override
    public T tryGetForUpdate(String id) throws PersistenceException {
        return this.read(id);
    }

    @Override
    public void unlock(T dao) throws PersistenceException {
    }

    @Override
    public void remove(String id) throws PersistenceException {
        this.map.remove(id);
    }

    @Override
    public void removeAll() throws PersistenceException {
        this.map.clear();
    }

    @Override
    public void write(T dao) throws PersistenceException {
        this.map.put(this.pd.getID(dao), dao);
    }

    @Override
    public void setCaching(boolean value) {
    }

    @Override
    public Boolean getCaching() {
        return Boolean.TRUE;
    }

    public void setWriteBehind(boolean value) {
    }

    public Boolean getWriteBehind() {
        return Boolean.FALSE;
    }

    @Override
    public void purge() {
        this.map.clear();
    }

    @Override
    public void setErrorHandler(DeserialisationErrorHandler j) {
    }
}

