/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.impl;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.PersistenceProperties;
import de.fzj.unicore.persist.impl.ColumnDescriptor;
import de.fzj.unicore.persist.impl.PersistImpl;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.h2.jdbcx.JdbcDataSource;

public class H2Persist<T>
extends PersistImpl<T> {
    private static final Logger logger = Logger.getLogger((String)("unicore.persistence." + H2Persist.class.getSimpleName()));
    protected Boolean serverMode = null;
    String connectionURL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws PersistenceException {
        Connection conn;
        super.init();
        if (this.config == null) {
            return;
        }
        Statement s = null;
        Connection connection = conn = this.getConnection();
        synchronized (connection) {
            try {
                s = conn.createStatement();
                String cacheSize = this.config.getSubkeyValue(PersistenceProperties.H2_CACHESIZE, this.pd.getTableName());
                s.execute("SET CACHE_SIZE " + cacheSize);
                logger.debug((Object)("Set H2 cache size to " + cacheSize + " kb."));
            }
            catch (SQLException ex) {
                logger.error((Object)"Error initing H2 database", (Throwable)ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {}
                this.disposeConnection(conn);
            }
        }
    }

    @Override
    public List<String> getSQLCreateTables() {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer columns = new StringBuffer();
        if (this.pd.getColumns() != null) {
            for (ColumnDescriptor c : this.pd.getColumns()) {
                columns.append("," + c.getColumn() + " " + this.getSQLStringType());
            }
        }
        String type = this.storeBinary != false ? "BLOB" : this.getSQLStringType();
        result.add("CREATE TABLE IF NOT EXISTS " + this.pd.getTableName() + " (id VARCHAR PRIMARY KEY, data " + type + columns.toString() + ")");
        return result;
    }

    @Override
    public String getSQLStringType() {
        return "VARCHAR";
    }

    @Override
    public String getSQLShutdown() {
        return "SHUTDOWN SCRIPT";
    }

    public Boolean getServerMode() {
        return this.serverMode;
    }

    public void setServerMode(boolean serverMode) {
        this.serverMode = serverMode;
    }

    @Override
    protected String createConnString() {
        String additionalParams;
        String tableName = this.pd.getTableName();
        String dir = null;
        if (this.serverMode == null) {
            this.serverMode = this.config == null ? false : Boolean.parseBoolean(this.config.getSubkeyValue(PersistenceProperties.H2_SERVER_MODE, tableName));
        }
        if (this.config != null) {
            dir = this.config.getSubkeyValue("directory", tableName);
        }
        if (dir == null) {
            try {
                dir = System.getProperty("java.io.tmpdir") + File.separator + String.valueOf(System.currentTimeMillis());
                File f = new File(dir);
                if (!f.mkdir()) {
                    throw new IOException("Can't create temporary directory");
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            logger.debug((Object)("Using fallback directory as storage: " + dir));
        }
        String params = "DB_CLOSE_ON_EXIT=FALSE";
        String string = additionalParams = this.config == null ? null : this.config.getSubkeyValue(PersistenceProperties.H2_OPTIONS, tableName);
        if (additionalParams != null) {
            params = params + ";" + additionalParams;
        }
        String id = this.getDatabaseName();
        if (this.serverMode.booleanValue()) {
            String host = this.config == null ? "localhost" : this.config.getSubkeyValue("host", this.pd.getTableName());
            String port = this.config == null ? "3306" : this.config.getSubkeyValue("port", this.pd.getTableName());
            this.connectionURL = "jdbc:h2:tcp://" + host + ":" + port + "/" + dir + File.separator + id + ";AUTO_RECONNECT=TRUE;" + params;
        } else {
            this.connectionURL = "jdbc:h2:file:" + dir + File.separator + id + ";" + params;
        }
        logger.info((Object)("Connecting to: " + this.connectionURL));
        return this.connectionURL;
    }

    @Override
    protected String getDriverName() {
        return "org.h2.Driver";
    }

    @Override
    protected ConnectionPoolDataSource getConnectionPoolDataSource() {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(this.createConnString());
        ds.setUser(this.getUserName());
        ds.setPassword(this.getPassword());
        return ds;
    }

    @Override
    protected DataSource getDataSource() {
        return null;
    }

    @Override
    protected String getUserName() {
        return "sa";
    }

    @Override
    protected String getPassword() {
        return "";
    }
}

