import org.w3.x2005.x08.addressing.EndpointReferenceType;
import de.fzj.unicore.uas.client.BaseUASClient;
import org.chemomentum.workflow.xmlbeans.WorkflowFactoryPropertiesDocument; 

try {
  if (commandLine.getArgs().size() != 2)
    throw new Exception("Usage: run-groovy -f test_workflow.groovy WORKFLOW_SERVICE_URL");

  def workflowServiceURL = commandLine.args[1];
  def epr = EndpointReferenceType.Factory.newInstance();
  def wfpd = null;
  epr.addNewAddress().setStringValue(workflowServiceURL);
  bc = new BaseUASClient(workflowServiceURL, epr, securityProperties);
  try {
    rpd = bc.GetResourcePropertyDocument();
    wfpd=WorkflowFactoryPropertiesDocument.Factory.parse(rpd.getGetResourcePropertyDocumentResponse().newInputStream());
  } catch (Exception e) { 
    throw new Exception('Unable to connect Workflow Service: ' + e.message);
  }
  workflows = wfpd.getWorkflowFactoryProperties().getAccessibleWorkflowReferenceArray(); 
  messageWriter.message "Found " + workflows.size() + " available workflows";
} catch (Exception e) {
  messageWriter.message e.message;
  e.printStackTrace();
  return;
}
