#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
our $plugin_version = '2.0';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

# Load configuration and check for commandline arguments
setup_plugin("$Bin/check_workflowservice.README", $plugin_version);
check_config("SERVICE_URL");
my $script_location = "$Bin/workflowservice_test.groovy";
check_file_existence($script_location);

# Execute something
our $TMPFILE = create_temp_file("check_workflowservice$$");
run("ucc", "run-groovy -f $script_location $config{'SERVICE_URL'}", $TMPFILE);

our $result = `head -1 $main::TMPFILE`;
$result =~ s/Found ([0-9]*) available workflows\n?/\1/;

# Check conditions
our @conditions = (
  {
    'test'       => '$main::result =~ /^\d+$/',
    'output'     => "OK: Workflow Service works normally, found workflows: $main::result.",
    'show_debug' => 0
  },
  {
    'test'       => '$main::result =~ /Unable to connect/',
    'output'     => "CRITICAL: Workflow service $config{'SERVICE_URL'} seems to be down: $main::result",
    'show_debug' => 0
  },
);
check_conditions(\@main::conditions);

# If executions goes here, it is abnormal situation...
exit_plugin("UNKNOWN: Unknown error", '`echo "See log for details:"; cat $main::TMPFILE`');
