#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
our $plugin_version = '3.0';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence &is_debug_enabled);

# Load configuration and check for commandline arguments
setup_plugin("$Bin/check_workflow.README", $plugin_version);

check_config("WORKFLOWSERVICE_NAME, GLOBAL_STORAGE_URL, SITES");

my $script_location = "$Bin/check_workflow_test.groovy";
check_file_existence($script_location);

# Execute something
our $TMPFILE = create_temp_file("check_workflow$$");
my $start = time();
run("ucc", "run-groovy -f $script_location $config{'WORKFLOWSERVICE_NAME'} $config{'GLOBAL_STORAGE_URL'} ".($config{'originalTimeout'}-50)." $config{'SITES'}", $TMPFILE);
my $uccTime = time() - $start;
our $result = `head -1 $main::TMPFILE`;
chomp $result;

# Check conditions
our @conditions = (
  {
    'test'       => '$main::result =~ /Wokflow succeeded! Time elapsed:/',
    'output'     => "OK: $main::result",
    'show_debug' => '`tail -n +2 $main::TMPFILE`'
  },
  {
    'test'       => '$main::result =~ /Workflow failed on/ || $main::result =~ /All jobs succeded, but some output files are missing/ || $main::result =~ /Workflow was unable to be executed on some sites/',
    'output'     => "WARNING: $main::result",
    'show_debug' => '`tail -n +2 $main::TMPFILE`'
  },
  {
    'test'       => '$main::result =~ /Workflow failed: jobs failed on too many sites/ || $main::result =~ /Workflow was unable to be executed on too many sites/',
    'output'     => "CRITICAL: $main::result",
    'show_debug' => '`tail -n +2 $main::TMPFILE`'
  },
  {
    'test'       => '$main::result =~ /Can\'t create list of target systems./ || $main::result =~ /^Could not invoke service.. Nested exception is org.codehaus.xfire.fault.XFireFault: Couldn\'t send message./',
    'output'     => "CRITICAL: Unable to connect to the Registry!",
    'show_debug' => '`cat $main::TMPFILE`'
  },
  {
    'test'       => '$main::result =~ /Unable to upload file/ || $main::result =~ /Workflow execution failed/ || $main::result =~ /WorkflowFactory service exists in Registry but doesn\'t respond/ || $main::result =~ /Location mapping service is not available!/ || $main::result =~ /Tracer service is not responding/ || $main::result =~ /Workflow Service failed during workflow execution/ || $main::result =~ /Unable to create workflow/ || $main::result =~ /Unable to list Target Systems in Registry/',
    'output'     => "CRITICAL: $main::result",
    'show_debug' => 0
  },
);
check_conditions(\@main::conditions);

# If executions goes here, it is abnormal situation...
exit_plugin("UNKNOWN: Unknown error", '`echo "See log for details:"; cat $main::TMPFILE`');
