import de.fzj.unicore.uas.client.BaseUASClient;
import org.chemomentum.common.ws.ITrace;
import de.fzj.unicore.uas.TargetSystemFactory;
import groovy.xml.QName;

def output = "";
try {
  tracers = registry.listServices(ITrace.PORT);
  tracers.each {
    try {
      client = new BaseUASClient(it.address.stringValue, it, securityProperties);
    } catch (Exception e) {
      throw new Exception ('Unable to connect to Tracer at '+it.address.stringValue, e);
    }
    try {
      def xml = new XmlParser().parseText(client.getResourcePropertyDocument());
      output += "W\t"+it.address.stringValue+"\t"+xml[new QName('http://www.chemomentum.org/tracer', 'TracerProperties')][0][new QName('http://unigrids.org/2006/04/types', 'Version')][0].value()[0]+"\n"; 
    } catch (java.lang.NullPointerException e) {
      output += "W\t"+it.address.stringValue+"\t0\n"; 
    } catch (Exception e) {
      throw new Exception ('Unable to parse data from Tracer at '+it.address.stringValue, e);
    }
  }

  tsfs=registry.listServices(TargetSystemFactory.TSF_PORT);
  tsfs.each {
    try {
      client = new BaseUASClient(it.address.stringValue, it, securityProperties);
    } catch (Exception e) {
      throw new Exception ('Unable to connect to TSF at '+it.address.stringValue, e);
    }
    try {
      def xml = new XmlParser().parseText(client.getResourcePropertyDocument());
      output += "U\t"+it.address.stringValue+"\t"+xml[new QName('http://unigrids.org/2006/04/services/tsf', 'TargetSystemFactoryProperties')][0][new QName('http://unigrids.org/2006/04/types', 'Version')][0].value()[0]+"\n"; 
    } catch (java.lang.NullPointerException e) {
      output += "U\t"+it.address.stringValue+"\t0\n";
    } catch (Exception e) {
      throw new Exception ('Unable to parse data from TSF at '+it.address.stringValue, e);
    }
  }
  messageWriter.message output.trim();

} catch (Exception e) {
  System.out.println(e.getMessage() + "\n"+e.getCause().getMessage());
  System.exit(1);
}
