#!/usr/bin/perl
# Authors: 
#   Mariusz Strzelecki <szczeles@mat.umk.pl>
#   Emir Imamagic <eimamagi@srce.hr>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
use URI;
our $plugin_version = '2.1';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

# Load configuration and check for commandline arguments
setup_plugin("$Bin/check_uvos.README", $plugin_version);
check_config("UVOS_URL, UCC_CONFIG");

# Get user DN
my $file = `cat $config{'UCC_CONFIG'}`;
$file =~ /(^|\n)credential.path=([^\n]*)/;              my $keystoreLocation = $2;
$file =~ /(^|\n)truststore.keystorePath=([^\n]*)/;      my $truststoreLocation = $2;
$file =~ /(^|\n)credential.password=([^\n]*)/;          my $keystorePassword = $2;
$file =~ /(^|\n)truststore.keystorePassword=([^\n]*)/;  my $truststorePassword = $2;
$file =~ /(^|\n)credential.keyAlias=([^\n]*)/;          my $keystoreAlias= $2;

chomp(my $dn = `keytool -keystore $keystoreLocation -list -alias '$keystoreAlias' -v -storepass $keystorePassword | grep Owner | head -1 | cut -d' ' -f 2-`);

# Generate config file
my $u = URI->new($config{'UVOS_URL'});
my ($scheme, $host, $port) = ($u->scheme, $u->host, $u->port);
my $CFGFILE = create_temp_file("uvosclc_config$$");
`chmod 600 $CFGFILE`;
open( CFG, ">$CFGFILE" ) or exit_plugin ("UNKNOWN: Unable to open UVOS config file $CFGFILE");
print CFG << "EOF";
uvos.protocol=$scheme
uvos.port=$port
uvos.host=$host
client.sslAuthnEnabled=true

credential.format=JKS
credential.path=$keystoreLocation
credential.keyAlias=$keystoreAlias
credential.password=$keystorePassword

truststore.type=keystore
truststore.keystorePath=$truststoreLocation
truststore.keystorePassword=$truststorePassword
truststore.keystoreFormat=JKS
EOF
close( CFG ) or exit_plugin ("UNKNOWN: Unable to close UVOS config file $CFGFILE");

$config{'UVOS_CLIENT_CONFIG'} = $CFGFILE;

# Execute UVOS CLC
our $TMPFILE = create_temp_file("check_uvos$$");
run("uvosclc", "-b getMyIds", $TMPFILE);

my @gotDNs = split("\n",  `grep 'Label: ' $TMPFILE  | cut -d} -f2`);
if (scalar @gotDNs > 0) {
  my $script_location = "$Bin/CompareDN.class";
  check_file_existence($script_location);

  my $exit_code = 0;
  foreach my $gotDN (@gotDNs) {
    $exit_code = run("java", "-cp $Bin CompareDN '$dn' '$gotDN'", '/dev/null');
    if ($exit_code == 0) {
      exit_plugin("OK: UVOS works, identity matches");
    }
  }
  if ($exit_code == 1 and `head -1 $main::TMPFILE` =~ /All identites of the current user are/) {
    exit_plugin("WARNING: Unexpected output (dn not found: $dn)", '`tail -n +2 $main::TMPFILE`');
  }
}


# Check conditions
our @conditions = (
  {
    'test'       => '`grep -c \'Authentication failure\' $main::TMPFILE` > 0',
    'output'     => "CRITICAL: Access Denied",
    'show_debug' => '`echo "See log for details:"; cat $main::TMPFILE`'
  },
  {
    'test'       => '`grep -c \'org.codehaus.xfire.fault.XFireFault\' $main::TMPFILE` > 0',
    'output'     => "CRITICAL: Unable to contact UVOS",
    'show_debug' => '`cat $main::TMPFILE | grep Caused | tail -1`'
  },
);
check_conditions(\@main::conditions);

# If executions goes here, it is abnormal situation...
exit_plugin("UNKNOWN: Unknown error", '`echo "See log for details:"; cat $main::TMPFILE`');
