import org.w3.x2005.x08.addressing.EndpointReferenceType
import de.fzj.unicore.uas.client.TSFClient;

if (commandLine.getArgs().size() != 2)
   throw new Exception("Wrong usage!");

def tsf_url = commandLine.args[1];
epr = EndpointReferenceType.Factory.newInstance();
epr.addNewAddress().setStringValue(tsf_url);
tsf = new TSFClient(tsf_url, epr, securityProperties);

def tsss = tsf.getAccessibleTargetSystems();
if (tsss.size() == 0) {
  try {
    tsf.createTSS();
  } catch (Exception e) {
    messageWriter.message "Problem when creating TSS:"
    e.printStackTrace();
    System.exit(2); 
  }
  tsss = tsf.getAccessibleTargetSystems();
}

messageWriter.message "TSSs available: " + tsss.size().toString()
