#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
our $plugin_version = '2.1';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

# Load configuration and check for commandline arguments
setup_plugin("$Bin/check_unicorex.README", $plugin_version);
check_config("SERVICE_URL");
my $script_location = "$Bin/check_unicorex_script.groovy";
check_file_existence($script_location);

# Execute UCC
our $TMPFILE = create_temp_file("check_unicorex$$");
run("ucc", "run-groovy -f $script_location $config{'SERVICE_URL'}", $TMPFILE);

# Check for TSF report from groovy script
open (FILE, $main::TMPFILE);
our @data = <FILE>;
close (FILE);

my @tss_regex = grep(/^TSSs available:/, @data);
$tss_regex[0] =~ / ([0-9]+)$/;
our $tss_number = $1;

# Check conditions
our @conditions = (
  {
    'test'       => '$main::tss_number >=1',
    'output'     => "OK: Found $main::tss_number TSS instance".($main::tss_number==1?'':'s')." | TSSInstances=$main::tss_number",
    'show_debug' => 0
  },
  {
    'test'       => 'not defined $main::tsf_name_ok',
    'output'     => "CRITICAL: Unable to find requested TSF on accessible sites list | TSSInstances=0",
    'show_debug' => 0
  },
  {
    'test'       => '$main::tss_number == 0',
    'output'     => "CRITICAL: TSF found but TSS cannot be created | TSSInstances=0",
    'show_debug' => '`echo "See log from checker for details:"; cat $main::TMPFILE`'
  },
);
check_conditions(\@main::conditions);

# If executions goes here, it is abnormal situation...
exit_plugin("UNKNOWN: Unknown error", '`echo "See log for details:"; cat $main::TMPFILE`');
