#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
our $plugin_version = '2.0';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

# Load configuration and check for commandline arguments
setup_plugin("$Bin/check_storagefactory.README", $plugin_version);
check_config("SF_URL");
my $check_sms = "$Bin/../check_sms/check_sms.pl";
check_file_existence($check_sms);

our $TMPFILE = create_temp_file("check_sf$$");
run("ucc", "create-storage -f $config{'SF_URL'}", $TMPFILE, 1);
chomp(my $address =  `cat $TMPFILE | grep ^https`);
if (!($address =~ /^https:\/\//)) {
  my @tempErrorArray = split("\n", $address);
  delete $tempErrorArray[2];
  exit_plugin("CRITICAL: Unable to create storage: $tempErrorArray[0]", "`cat $main::TMPFILE`");
}

my $CFGFILE = create_temp_file("check_sms_temp_config$$");
open( CFG, ">$CFGFILE" ) or exit_plugin ("UNKNOWN: Unable to open check_sms config file $CFGFILE");
print CFG << "EOF";
UCC_PATH="$config{'UCC_PATH'}"
UCC_CONFIG="$config{'UCC_CONFIG'}"
REGISTRY_URL="$config{'REGISTRY_URL'}"
LOGS_DIR="$config{'LOGS_DIR'}"
SMS_ADDRESS="$address"
FILE_SIZE_KBS="10"
EOF
close( CFG ) or exit_plugin ("UNKNOWN: Unable to close check_sms config file $CFGFILE");

# Execute check_sms
my $exit_code = run("probe", "$check_sms -f $CFGFILE -v 0", $TMPFILE);
if ($exit_code != 0) {
  chomp(my $check_sms_output = `cat $TMPFILE`);
  exit_plugin("CRITICAL: SMS created at $address does not work properly", "'check_sms output: $check_sms_output'");
}

# Destroy SMS
$exit_code = run("ucc", "wsrf destroy $address", $TMPFILE, 1);
if ($exit_code != 0) {
  my @tempErrorArray = split("\n", `cat $TMPFILE`);
  delete $tempErrorArray[2];
  exit_plugin("WARNING: Storage created by storage factory works but is unable to be removed: $tempErrorArray[0]", "'$tempErrorArray[1]'");
}

exit_plugin("OK: Storage factory at $config{'SF_URL'} works");
