#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
our $plugin_version = '2.0';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

# Load configuration and check for commandline arguments
setup_plugin("$Bin/check_sms.README", $plugin_version);
check_config('SMS_ADDRESS');
check_config('FILE_SIZE_KBS');
$config{'PROTOCOL'} = 'BFT' if not defined $config{'PROTOCOL'};
#my $smsAddr = $config{'SMS_ADDRESS'};
#$config{'SMS_ADDRESS'} = "$config{'PROTOCOL'}:$config{'SMS_ADDRESS'}";


# Execute something
our $TMPFILE = create_temp_file("check_sms$$");
our $DATAFILE = create_temp_file("check_sms$$.file");
our $DATAFILE2 = create_temp_file("check_sms$$.file.downloaded");
our $REMOTEFILE = "check_sms$$";

# Generate random file
print `dd if=/dev/urandom of=$main::DATAFILE bs=1024 count=$config{'FILE_SIZE_KBS'} >/dev/null 2>&1`;
if ($? != 0) {
  exit_plugin("CRITICAL: Unable to generate random file to test!");
}

# Upload file
my $ret = run("ucc", "put-file -s $main::DATAFILE -t $config{'SMS_ADDRESS'}#$main::REMOTEFILE -v -y -P $config{'PROTOCOL'}", $TMPFILE, 1);

our @conditions = (
  {
    'test'       => '`grep -c "SMS contacted, server reply" $main::TMPFILE` != 1',
    'output'     => "CRITICAL: Unable to get access to the SMS at $config{'SMS_ADDRESS'}",
    'show_debug' => '`echo "See log from ucc for details:"; cat $main::TMPFILE`'
  },
  {
    'test'       => '`grep -c "java.io.IOException: Can\'t write data, server returned Internal Server Error" $main::TMPFILE` != 0',
    'output'     => "CRITICAL: Unable to write file at server side on $config{'SMS_ADDRESS'}",
    'show_debug' => '`echo "See log from ucc for details:"; cat $main::TMPFILE`'
  },
  {
    'test'       => '`grep -c "is not a valid location." $main::TMPFILE` != 0',
    'output'     => "CRITICAL: Unable to upload file - $config{'SMS_ADDRESS'}/$main::REMOTEFILE is not a valid location.",
    'show_debug' => '`echo -e "Probably SMS is not available, see ucc log:"; cat $main::TMPFILE`'
  },
  {
    'test'       => '$ret != 0 or `grep -c "Can\'t put file." $main::TMPFILE` != 0',
    'output'     => "CRITICAL: Unable to upload file to $config{'SMS_ADDRESS'}, reason uknown",
    'show_debug' => '`echo "See ucc log to determine error:"; cat $main::TMPFILE`'
  }
);
check_conditions(\@main::conditions);
exit_plugin("UNKNOWN: Wrong upload rate syntax!") unless (`cat $main::TMPFILE` =~ m/Rate: ([^k]+)kB\/sec\./);
my $UPLOADRATE = $1;
$UPLOADRATE =~ s/,//g;
$UPLOADRATE =~ s/[^0-9\.]//g;

our $CLEANUP='run("ucc", "rm -q $config{\'SMS_ADDRESS\'}#$main::REMOTEFILE");';

# Download file
$ret = run("ucc", "get-file -t $main::DATAFILE2 -s $config{'SMS_ADDRESS'}#$main::REMOTEFILE -v -y -P $config{'PROTOCOL'}", $TMPFILE, 1);

@conditions = (
  {
    'test'       => '$ret != 0 or `grep -c "Can\'t get file." $main::TMPFILE` != 0',
    'output'     => "CRITICAL: Unable to get file from $config{'SMS_ADDRESS'}$main::REMOTEFILE",
    'show_debug' => '`echo "See log from ucc for details:"; cat $main::TMPFILE`'
  },
  {
    'test'       => '`file -b $main::DATAFILE2` =~ "empty"',
    'output'     => "CRITICAL: Download succeeded, but downloaded file is empty ($main::REMOTEFILE on $config{'SMS_ADDRESS'})",
    'show_debug' => 0
  }
);
check_conditions(\@main::conditions);
exit_plugin("UNKNOWN: Wrong download rate syntax!") unless (`cat $main::TMPFILE` =~ m/Rate: ([^k]+)kB\/sec\./);
my $DOWNLOADRATE = $1;
$DOWNLOADRATE =~ s/,//g;
$DOWNLOADRATE =~ s/[^0-9\.]//g;

chomp(my $protocol = `grep 'File transfer URL' $main::TMPFILE | tail -1`);
exit_plugin("UNKNOWN: Unable to determine protocol") unless (`grep 'File transfer URL' $main::TMPFILE | tail -1` =~ m/FileTransfer([^?]+)/);
$protocol = $1;

# Compare files
`cmp -s $main::DATAFILE $main::DATAFILE2`;

if ( $? != 0 ) {
  $CLEANUP = '';
  @conditions = (
    {
      'test'       => '$? != 0',
      'output'     => "CRITICAL: Downloaded file differs from uploaded one.",
      'show_debug' => "`echo Check files $main::DATAFILE, $main::DATAFILE2 on local machine and $main::REMOTEFILE on $config{'SMS_ADDRESS'}. Files aren't deleted!`"
    }
  );
  check_conditions(\@main::conditions);
}

if ($protocol ne $config{"PROTOCOL"}) {
  exit_plugin("WARNING: SMS at $config{'SMS_ADDRESS'} works, but has been tested with protocol $protocol instead of requested $config{'PROTOCOL'}");
}
# If executions goes here, it's great
exit_plugin("OK: SMS at $protocol:$config{'SMS_ADDRESS'} works with U:$UPLOADRATE kB/s, D:$DOWNLOADRATE kB/s | UploadRate=${UPLOADRATE}KB DownloadRate=${DOWNLOADRATE}KB");
