import org.chemomentum.common.impl.gris.GridResourceInfoDownloadClient;
import org.w3.x2005.x08.addressing.EndpointReferenceType;
import org.chemomentum.common.ws.IGridResourceInformationService;
import javax.xml.namespace.QName;
import org.chemomentum.common.impl.gris.ResourceObject;

try {

  if (commandLine.getArgs().size() != 2)
    throw new Exception("Wrong usage!");

  def myUrl = commandLine.args[1];
  def myEpr = EndpointReferenceType.Factory.newInstance();
  myEpr.addNewAddress().setStringValue(myUrl);
  messageWriter.verbose "Connecting to "+myUrl;
  grisClient = new GridResourceInfoDownloadClient(myUrl, myEpr, securityProperties);
  def candidates;
  try {
    candidates = grisClient.getAllResources();
  } catch (org.codehaus.xfire.XFireRuntimeException e) {
    throw new Exception("Unable to contact Service Orchestrator at "+myUrl+": "+e.getCause());
  }

  counter = 0;
  candidates.each {
    counter++;
    messageWriter.verbose it.epr.address.stringValue
  }
  messageWriter.message "Sites found by GRIS: "+counter;
} catch (Exception e) {
  messageWriter.message e.getMessage();
  e.printStackTrace();
}

