#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
our $plugin_version = '2.0';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

# Load configuration and check for commandline arguments
setup_plugin("$Bin/check_servorch.README", $plugin_version);
check_config("SERVORCH_URL");
my $script_location = "$Bin/contact_gris.groovy";
check_file_existence($script_location);

my $url = $config{'SERVORCH_URL'};
$url =~ s/ServiceOrchestrator/GridResourceInformationService/;

# Execute something
our $TMPFILE = create_temp_file("check_servorch$$");
run("ucc", "run-groovy -f $script_location $url", $TMPFILE);

our $result = `head -1 $main::TMPFILE`;
$result =~ s/Sites found by GRIS: ([0-9]*)\n?/\1/;

# Check conditions
our @conditions = (
  {
    'test'       => '$main::result =~ /^\d+$/ && $main::result > 0',
    'output'     => "OK: Service Orchestator appears to work, sites registered in GRIS: $main::result.",
    'show_debug' => 0
  },
  {
    'test'       => '$main::result =~ /^\d+$/ && $main::result == 0',
    'output'     => "CRITICAL: Unable to find any resource in GRIS!",
    'show_debug' => 0
  },
  {
    'test'       => '$main::result =~ /Unable to contact Service Orchestrator/',
    'output'     => "CRITICAL: $main::result",
    'show_debug' => 0
  },
);
check_conditions(\@main::conditions);

# If executions goes here, it is abnormal situation...
exit_plugin("UNKNOWN: Unknown error", '`echo "See log for details:"; cat $main::TMPFILE`');
