#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
our $plugin_version = '2.0';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

# Load configuration and check for commandline arguments
setup_plugin("$Bin/check_registry.README", $plugin_version);

# Execute UCC
our $TMPFILE = create_temp_file("check_registry$$");
run("ucc", "run-groovy -e 'registry.listEntries().each { messageWriter.message it.memberServiceEPR.address.stringValue() }'", $TMPFILE, 1);

# Check for discovered services
our @data = ();
open (FILE, $TMPFILE);
while (<FILE>) {
  push(@data, $1);
}
close (FILE);

# Check if some are missing
our @required_services =  split(/,\s*/, $config{'REQUIRED_SERVICES'});
our @not_found = ();
while (my $v = shift(@required_services)) {
  if (!grep ($_ eq $v, @data)) { push(@not_found, $v)  };
}

# Check conditions
our @conditions = (
  {
    'test'       => '`grep -c "\(Problem when forwarding a client request to a VSite\|org.codehaus.xfire.fault.XFireFault: Couldn\'t send message.\)" $main::TMPFILE` > 0',
    'output'     => "CRITICAL: Unable to connect the Registry",
    'show_debug' => '`echo "See ucc log for details:"; cat $main::TMPFILE`'
  },
  {
    'test'       => '`grep -c "An error occurred." $main::TMPFILE` > 0',
    'output'     => "CRITICAL: Unable to connect to the Registry",
    'show_debug' => '`echo "See ucc log for details:"; cat $main::TMPFILE`'
  },
  {
    'test'       => 'scalar @main::data == 0',
    'output'     => "CRITICAL: None services found",
    'show_debug' => '`echo "See ucc log for details:"; cat $main::TMPFILE`'
  },
  {
    'test'       => 'scalar @main::not_found == 0',
    'output'     => "OK: Registry works, ".(scalar @data)." services found",
    'show_debug' => 0
  },
  {
    'test'       => 'scalar @main::not_found != 0',
    'output'     => "CRITICAL: Some required services not found: @main::not_found",
    'show_debug' => '`echo "Found services:"; cat $main::TMPFILE`',
  }
);
check_conditions(\@main::conditions);

# If executions goes here, it is abnormal situation...
exit_plugin("UNKNOWN: Unknown error", '`echo "See log for details:"; cat $main::TMPFILE`');
