#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
our $plugin_version = '2.0';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

setup_plugin("$Bin/check_gateway.README", $plugin_version);
check_config("GATEWAY_URL, UCC_CONFIG");

my $script_location = "$Bin/CheckGateway.class";
check_file_existence($script_location);

# Execute something
our $TMPFILE = create_temp_file("check_gateway$$");
our $exit_code = run("java", "-cp $Bin CheckGateway $config{'GATEWAY_URL'} $config{'UCC_CONFIG'}", $TMPFILE);

# Check for discovered VSites
open (FILE, $TMPFILE);
our @data = <FILE>;
close (FILE);

# Check if some are missing
our @required_sites =  split(/,\s*/, $config{'REQUIRED_VSITES'});
our @not_found = ();
while (my $v = shift(@required_sites)) {
  if (!grep (/$v/, @data)) { push(@not_found, $v)  };
}

# Check conditions
our @conditions = (
  {
    'test'       => '$main::exit_code ==0 and scalar @main::data == 0',
    'output'     => "WARNING: Unable to get Gateway output or no services found",
    'show_debug' => 0
  },
  {
    'test'       => '$main::exit_code ==0 and scalar @main::not_found == 0',
    'output'     => "OK: Gateway works properly, ".(scalar @main::data)." service".(scalar @main::data > 1 ? 's' : '')." found",
    'show_debug' => 0
  },
  {
    'test'       => '$main::exit_code ==0 and scalar @main::not_found > 0',
    'output'     => "WARNING: Required services not found: @main::not_found",
    'show_debug' => '`echo "All registered services are:"; cat $main::TMPFILE`'
  },
  {
    'test'       => '`grep -c \'Connection refused\' $main::TMPFILE` > 0',
    'output'     => 'CRITICAL: Connection refused',
    'show_debug' => 0
  },
  {
    'test'       => '`grep -c \'Connection timed out\' $main::TMPFILE` > 0',
    'output'     => "CRITICAL: Connection timed out",
    'show_debug' => 0
  },
  {
    'test'       => '`grep -c \'No route\' $main::TMPFILE` > 0',
    'output'     => "CRITICAL: No route to host, check connection",
    'show_debug' => 0
  },
  {
    'test'       => '`grep -c \'Keystore was tampered with, or password was incorrect\' $main::TMPFILE` > 0',
    'output'     => "UNKNOWN: Keystore password you provided is wrong",
    'show_debug' => 0
  },
  {
    'test'       => '`grep -c \'No such file or directory\' $main::TMPFILE` > 0',
    'output'     => "UNKNOWN: Keystore path you provided is not valid",
    'show_debug' => 0
  },
  {
    'test'       => '`grep -c \'java.net.UnknownHostException\' $main::TMPFILE` > 0',
    'output'     => "CRITICAL: Unknown gateway host",
    'show_debug' => 0
  },
  {
    'test'       => '`grep -c \'Received fatal alert: bad_certificate\' $main::TMPFILE` > 0',
    'output'     => "CRITICAL: SSL connection cannot be trusted",
    'show_debug' => 0
  }

);
check_conditions(\@main::conditions);

# If executions goes here, it is abnormal situation...
exit_plugin("UNKNOWN: Unknown error", '`echo "See log for details:"; cat $main::TMPFILE`');
