#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
our $plugin_version = '2.0';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Defaults
my $warn = "10737418240"; # 10 GB
my $crit = "1073741824"; # 1 GB

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

sub convert_bytes ($$){
  my ($bytes, $dec) = @_;     
  foreach my $posfix (qw(bytes kB MB GB TB PB EB ZB YB)) {
    return sprintf("\%.${dec}f \%s", $bytes, $posfix) if $bytes < 1024;
    $bytes = $bytes / 1024;
  }
}

# Load configuration and check for commandline arguments
setup_plugin("$Bin/check_freespace.README", $plugin_version);
check_config("SMS_URL");

$warn = $config{'warning'} if (defined $config{'warning'});
$crit = $config{'critical'} if (defined $config{'critical'});
exit_plugin("UNKNOWN: Given warning threshold ($warn) is smaller than critical ($crit)") if $warn < $crit;

# Get address of home storages if given
if ($config{'SMS_URL'} =~ m#^u6://([^/]*)/home#i)
{
  my $siteName = $1;
  my $TMP2 = create_temp_file("check_freespace2$$");
  run("ucc", "list-storages", $TMP2);
  my $out = `cat $TMP2`;
  if ($out =~ m#(?:\n|^)Home *([^\n]*/$siteName/[^\n]*)#i) {
    $config{'SMS_URL'} = $1; 
  } else {
    exit_plugin('UNKNOWN: Unable to determine Home storage URL');
  }
}

# Execute something
our $TMPFILE = create_temp_file("check_freespace$$");
if (!run("ucc", "wsrf getproperties $config{'SMS_URL'}", $TMPFILE)) {
  my $out = `cat $main::TMPFILE`;
  if (!($out =~ m|<jsdl:DiskSpace>\s*<jsdl:Exact>([^<]*)|)) {
    exit_plugin("WARNING: SMS at $config{'SMS_URL'} doesn't provide free space information!");
  }
  $out = "There is ".convert_bytes(int($1),2)." of free space on $config{'SMS_URL'} | FreeSpace=".int($1)."B;$warn;$crit";

  if (int($1) > $warn) {
    exit_plugin("OK: $out");
  } elsif (int($1) > $crit) {
    exit_plugin("WARNING: $out");
  } else {
    exit_plugin("CRITICAL: $out");
  }
} else {
  exit_plugin("UNKNOWN: Cannot get access to the SMS $config{'SMS_URL'}");
}
