#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
our $plugin_version = '2.0';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

# Load configuration and check for commandline arguments
setup_plugin("$Bin/check_cis.README", $plugin_version);
check_config("CIS_URL");

# Execute something
our $TMPFILE = create_temp_file("check_cis$$");
run("ucc", "cis-showallinfo", $TMPFILE, 1);
my $head = `cat $TMPFILE | head -1`;
if ($head =~ /Number of records in CIS: ([0-9]*)/) {
  exit_plugin("OK: CIS works and gives information of $1 CIP".($1>1?'s':'')) if ($1 > 0);
  exit_plugin("WARNING: CIS works, but does not give any information about CIPs");
}
exit_plugin("CRITICAL: CIS does not work", "`cat $TMPFILE`");
