#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
our $plugin_version = '2.0';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

# Load configuration and check for commandline arguments
setup_plugin("$Bin/check_cip.README", $plugin_version);
check_config("CIP_URL");

# Execute something
our $TMPFILE = create_temp_file("check_cip$$");
run("ucc", "cip-query $config{'CIP_URL'} -t '/Jobs'", $TMPFILE, 1);
my $jobs = `cat $TMPFILE | grep TotalJobs | tr -cd [:digit:]`;
if ($jobs ne '') {
  exit_plugin('OK: CIP works, total jobs: '.int($jobs)) if int($jobs) > 0;
  exit_plugin('WARNING: CIP works, but does not process information.'); 
}
exit_plugin("CRITICAL: CIP does not respond.", "`head -2 $TMPFILE | tail -1`") if (`grep -c 'Error querying CIS info provider' $TMPFILE` > 0);

exit_plugin('WARNING: CIP responds but seems to be not initialized.') if (`grep 'inf:GetInfoResponse' $TMPFILE`);

# If executions goes here, it is abnormal situation...
exit_plugin("UNKNOWN: Unknown error", '`echo "See log for details:"; cat $main::TMPFILE`');
