#!/usr/bin/perl
# Author: Mariusz Strzelecki <szczeles@mat.umk.pl>
# Don't use Nagios embedded perl
# nagios: -epn

use strict;
use Date::Parse;
our $plugin_version = '2.0';

# Let $Bin store absolute path of script directory
use FindBin '$Bin';

# Look for commons.pm in following directories
use lib "$Bin";
use lib "$Bin/..";

# Defaults
my $warn = 30; # 30 days
my $crit = 3; # 3 days

# Load common functions
use commons qw(%config &exit_plugin &setup_plugin &message &check_conditions &create_temp_file &check_config &run &check_file_existence);

setup_plugin("$Bin/check_certificate.README", $plugin_version, "HOST, PORT");

$warn = $config{'warning'} if (defined $config{'warning'});
$crit = $config{'critical'} if (defined $config{'critical'});

our $TMPFILE = create_temp_file("check_certificate$$");
my $exit_code = run("other", "nohup openssl s_client -connect $config{'HOST'}:$config{'PORT'} -prexit", $TMPFILE, 1);
if (($exit_code != 1 and $exit_code != 0 )or `grep -c \'BEGIN CERTIFICATE\' $TMPFILE` == 0) {
  exit_plugin("CRITICAL: Unable to connect $config{'HOST'}:$config{'PORT'}", '`cat $main::TMPFILE`');
}
chomp(my $expiresAt = `openssl x509 -noout -in $TMPFILE -dates | grep notAfter | cut -f2 -d'='`);
my $days = (str2time($expiresAt) - time())/(60 * 60 * 24);
chomp(our $subject = `openssl x509 -noout -in $TMPFILE -subject |  cut -f2- -d'='`);

my $message = ": Certificate at $config{'HOST'}:$config{'PORT'} will expire in ".sprintf("%.2f", $days)." day".($days != 1 ? 's' : '').' ('.$expiresAt.')';
if ($days > $warn) {
  $message = 'OK'.$message;
} elsif ($days > $crit) {
  $message = 'WARNING'.$message;
} elsif ($days > 1) {
  $message = 'CRITICAL'.$message;
} elsif ($days == 1) {
  $message = "CRITICAL: Certificate at $config{'HOST'}:$config{'PORT'} will expire today!";
} else {
  $message = "CRITICAL: Certificate at $config{'HOST'}:$config{'PORT'} expired";
}
exit_plugin($message, '"Subject: '.$subject.'"');
