/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.net.InetSocketAddress;
import java.net.URI;
import javax.servlet.Servlet;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.transport.TransportServerSupport;
import org.apache.activemq.transport.http.HttpTransportFactory;
import org.apache.activemq.transport.http.HttpTunnelServlet;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.transport.xstream.XStreamWireFormat;
import org.apache.activemq.util.ServiceStopper;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.GzipHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class HttpTransportServer
extends TransportServerSupport {
    private URI bindAddress;
    private TextWireFormat wireFormat;
    private Server server;
    private Connector connector;
    private HttpTransportFactory transportFactory;

    public HttpTransportServer(URI uri, HttpTransportFactory factory) {
        super(uri);
        this.bindAddress = uri;
        this.transportFactory = factory;
    }

    @Override
    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    public TextWireFormat getWireFormat() {
        if (this.wireFormat == null) {
            this.wireFormat = this.createWireFormat();
        }
        return this.wireFormat;
    }

    public void setWireFormat(TextWireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    protected TextWireFormat createWireFormat() {
        return new XStreamWireFormat();
    }

    protected void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    protected void doStart() throws Exception {
        this.server = new Server();
        if (this.connector == null) {
            this.connector = new SelectChannelConnector();
        }
        this.connector.setHost(this.bindAddress.getHost());
        this.connector.setPort(this.bindAddress.getPort());
        this.connector.setServer(this.server);
        this.server.addConnector(this.connector);
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)this.server, "/", 0);
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)new HttpTunnelServlet());
        contextHandler.addServlet(holder, "/");
        contextHandler.setAttribute("acceptListener", (Object)this.getAcceptListener());
        contextHandler.setAttribute("wireFormat", (Object)this.getWireFormat());
        contextHandler.setAttribute("transportFactory", (Object)this.transportFactory);
        contextHandler.setAttribute("transportOptions", (Object)this.transportOptions);
        GzipHandler gzipHandler = new GzipHandler();
        contextHandler.setHandler((Handler)gzipHandler);
        this.server.start();
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        Server temp = this.server;
        this.server = null;
        if (temp != null) {
            temp.stop();
        }
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return null;
    }
}

