/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.stax.DepthXMLStreamReader;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class STAXUtils {
    private static final String XML_NS = "http://www.w3.org/2000/xmlns/";
    private static final Log logger = LogFactory.getLog(STAXUtils.class);
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private static final XMLOutputFactory xmlOututFactory = XMLOutputFactory.newInstance();
    private static boolean inFactoryConfigured;
    private static final Map factories;

    public static boolean skipToStartOfElement(XMLStreamReader in) throws XMLStreamException {
        int code = in.getEventType();
        while (code != 8) {
            if (code == 1) {
                return true;
            }
            code = in.next();
        }
        return false;
    }

    public static boolean toNextElement(DepthXMLStreamReader dr) {
        if (dr.getEventType() == 1) {
            return true;
        }
        if (dr.getEventType() == 2) {
            return false;
        }
        try {
            int depth = dr.getDepth();
            int event = dr.getEventType();
            while (dr.getDepth() >= depth && dr.hasNext()) {
                if (event == 1 && dr.getDepth() == depth + 1) {
                    return true;
                }
                if (event == 2) {
                    --depth;
                }
                event = dr.next();
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    public static boolean skipToStartOfElement(DepthXMLStreamReader in) throws XMLStreamException {
        int code = in.getEventType();
        while (code != 8) {
            if (code == 1) {
                return true;
            }
            code = in.next();
        }
        return false;
    }

    public static void copy(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int read = 0;
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    ++read;
                    STAXUtils.writeStartElement(reader, writer);
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (--read > 0) break;
                    return;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 13: {
                    break;
                }
                case 12: {
                    writer.writeCData(reader.getText());
                    break;
                }
            }
            event = reader.next();
        }
    }

    private static void writeStartElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String nsPrefix;
        int i;
        String local = reader.getLocalName();
        String uri = reader.getNamespaceURI();
        String prefix = reader.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        String boundPrefix = writer.getPrefix(uri);
        boolean writeElementNS = false;
        if (boundPrefix == null || !prefix.equals(boundPrefix)) {
            writeElementNS = true;
        }
        if (uri != null && uri.length() > 0) {
            if (prefix.length() == 0) {
                writer.writeStartElement(local);
                writer.setDefaultNamespace(uri);
            } else {
                writer.writeStartElement(prefix, local, uri);
                writer.setPrefix(prefix, uri);
            }
        } else {
            writer.writeStartElement(reader.getLocalName());
        }
        for (i = 0; i < reader.getNamespaceCount(); ++i) {
            String nsURI = reader.getNamespaceURI(i);
            nsPrefix = reader.getNamespacePrefix(i);
            if (nsURI == null) {
                nsURI = "";
            }
            if (nsPrefix == null) {
                nsPrefix = "";
            }
            if (nsPrefix.length() == 0) {
                writer.writeDefaultNamespace(nsURI);
            } else {
                writer.writeNamespace(nsPrefix, nsURI);
            }
            if (uri == null || !nsURI.equals(uri) || !nsPrefix.equals(prefix)) continue;
            writeElementNS = false;
        }
        if (writeElementNS && uri != null) {
            if (prefix == null || prefix.length() == 0) {
                writer.writeDefaultNamespace(uri);
            } else {
                writer.writeNamespace(prefix, uri);
            }
        }
        for (i = 0; i < reader.getAttributeCount(); ++i) {
            String ns = reader.getAttributeNamespace(i);
            nsPrefix = reader.getAttributePrefix(i);
            if (ns == null || ns.length() == 0) {
                writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            if (nsPrefix == null || nsPrefix.length() == 0) {
                writer.writeAttribute(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    public static void writeDocument(Document d, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        STAXUtils.writeDocument(d, writer, true, repairing);
    }

    public static void writeDocument(Document d, XMLStreamWriter writer, boolean writeProlog, boolean repairing) throws XMLStreamException {
        if (writeProlog) {
            writer.writeStartDocument();
        }
        Element root = d.getDocumentElement();
        STAXUtils.writeElement(root, writer, repairing);
        if (writeProlog) {
            writer.writeEndDocument();
        }
    }

    public static void writeElement(Element e, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        boolean declareNamespace;
        String prefix = e.getPrefix();
        String ns = e.getNamespaceURI();
        String localName = e.getLocalName();
        if (prefix == null) {
            prefix = "";
        }
        if (localName == null && (localName = e.getNodeName()) == null) {
            throw new IllegalStateException("Element's local name cannot be null!");
        }
        String decUri = null;
        NamespaceContext ctxt = writer.getNamespaceContext();
        if (ctxt != null) {
            decUri = ctxt.getNamespaceURI(prefix);
        }
        boolean bl = declareNamespace = decUri == null || !decUri.equals(ns);
        if (ns == null || ns.length() == 0) {
            writer.writeStartElement(localName);
        } else {
            writer.writeStartElement(prefix, localName, ns);
        }
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            String attrPrefix = "";
            int prefixIndex = name.indexOf(58);
            if (prefixIndex != -1) {
                attrPrefix = name.substring(0, prefixIndex);
                name = name.substring(prefixIndex + 1);
            }
            if (attrPrefix.equals("xmlns")) {
                writer.writeNamespace(name, attr.getNodeValue());
                if (!name.equals(prefix) || !attr.getNodeValue().equals(ns)) continue;
                declareNamespace = false;
                continue;
            }
            if (name.equals("xmlns") && attrPrefix.equals("")) {
                writer.writeNamespace("", attr.getNodeValue());
                if (!attr.getNodeValue().equals(ns)) continue;
                declareNamespace = false;
                continue;
            }
            writer.writeAttribute(attrPrefix, attr.getNamespaceURI(), name, attr.getNodeValue());
        }
        if (declareNamespace && repairing) {
            writer.writeNamespace(prefix, ns);
        }
        NodeList nodes = e.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            STAXUtils.writeNode(n, writer, repairing);
        }
        writer.writeEndElement();
    }

    public static void writeNode(Node n, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        if (n instanceof Element) {
            STAXUtils.writeElement((Element)n, writer, repairing);
        } else if (n instanceof Text) {
            writer.writeCharacters(((Text)n).getNodeValue());
        } else if (n instanceof CDATASection) {
            writer.writeCData(((CDATASection)n).getData());
        } else if (n instanceof Comment) {
            writer.writeComment(((Comment)n).getData());
        } else if (n instanceof EntityReference) {
            writer.writeEntityRef(((EntityReference)n).getNodeValue());
        } else if (n instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)n;
            writer.writeProcessingInstruction(pi.getTarget(), pi.getData());
        }
    }

    public static Document read(DocumentBuilder builder, XMLStreamReader reader, boolean repairing) throws XMLStreamException {
        Document doc = builder.newDocument();
        STAXUtils.readDocElements(doc, reader, repairing);
        return doc;
    }

    private static Document getDocument(Node parent) {
        return parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
    }

    private static Element startElement(Node parent, XMLStreamReader reader, boolean repairing) throws XMLStreamException {
        String prefix;
        Document doc = STAXUtils.getDocument(parent);
        Element e = doc.createElementNS(reader.getNamespaceURI(), reader.getLocalName());
        if (reader.getPrefix() != null && reader.getPrefix() != "") {
            e.setPrefix(reader.getPrefix());
        }
        parent.appendChild(e);
        for (int ns = 0; ns < reader.getNamespaceCount(); ++ns) {
            String uri = reader.getNamespaceURI(ns);
            prefix = reader.getNamespacePrefix(ns);
            STAXUtils.declare(e, uri, prefix);
        }
        for (int att = 0; att < reader.getAttributeCount(); ++att) {
            String name = reader.getAttributeLocalName(att);
            prefix = reader.getAttributePrefix(att);
            if (prefix != null && prefix.length() > 0) {
                name = prefix + ":" + name;
            }
            Attr attr = doc.createAttributeNS(reader.getAttributeNamespace(att), name);
            attr.setValue(reader.getAttributeValue(att));
            e.setAttributeNode(attr);
        }
        reader.next();
        STAXUtils.readDocElements(e, reader, repairing);
        if (repairing && !STAXUtils.isDeclared(e, reader.getNamespaceURI(), reader.getPrefix())) {
            STAXUtils.declare(e, reader.getNamespaceURI(), reader.getPrefix());
        }
        return e;
    }

    private static boolean isDeclared(Element e, String namespaceURI, String prefix) {
        Attr att = prefix != null && prefix.length() > 0 ? e.getAttributeNodeNS(XML_NS, "xmlns:" + prefix) : e.getAttributeNode("xmlns");
        if (att != null && att.getNodeValue().equals(namespaceURI)) {
            return true;
        }
        if (e.getParentNode() instanceof Element) {
            return STAXUtils.isDeclared((Element)e.getParentNode(), namespaceURI, prefix);
        }
        return false;
    }

    public static void readDocElements(Node parent, XMLStreamReader reader, boolean repairing) throws XMLStreamException {
        Document doc = STAXUtils.getDocument(parent);
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    STAXUtils.startElement(parent, reader, repairing);
                    if (!(parent instanceof Document)) break;
                    if (reader.hasNext()) {
                        reader.next();
                    }
                    return;
                }
                case 2: {
                    return;
                }
                case 13: {
                    break;
                }
                case 10: {
                    break;
                }
                case 4: {
                    if (parent == null) break;
                    parent.appendChild(doc.createTextNode(reader.getText()));
                    break;
                }
                case 5: {
                    if (parent == null) break;
                    parent.appendChild(doc.createComment(reader.getText()));
                    break;
                }
                case 12: {
                    parent.appendChild(doc.createCDATASection(reader.getText()));
                    break;
                }
                case 3: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
                case 9: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
            }
            if (!reader.hasNext()) continue;
            event = reader.next();
        }
    }

    private static void declare(Element node, String uri, String prefix) {
        if (prefix != null && prefix.length() > 0) {
            node.setAttributeNS(XML_NS, "xmlns:" + prefix, uri);
        } else if (uri != null) {
            node.setAttributeNS(XML_NS, "xmlns", uri);
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding, MessageContext ctx) {
        XMLOutputFactory factory = STAXUtils.getXMLOutputFactory(ctx);
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            XMLStreamWriter writer = factory.createXMLStreamWriter(out, encoding);
            return writer;
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    public static XMLOutputFactory getXMLOutputFactory(MessageContext ctx) {
        if (ctx == null) {
            return xmlOututFactory;
        }
        Object outFactoryObj = ctx.getContextualProperty("xfire.stax.output.factory");
        if (outFactoryObj instanceof XMLOutputFactory) {
            return (XMLOutputFactory)outFactoryObj;
        }
        if (outFactoryObj instanceof String) {
            String outFactory = (String)outFactoryObj;
            XMLOutputFactory xof = (XMLOutputFactory)factories.get(outFactory);
            if (xof == null) {
                xof = (XMLOutputFactory)STAXUtils.createFactory(outFactory, ctx);
                factories.put(outFactory, xof);
            }
            return xof;
        }
        return xmlOututFactory;
    }

    public static XMLInputFactory getXMLInputFactory(MessageContext ctx) {
        if (ctx == null) {
            return xmlInputFactory;
        }
        Object inFactoryObj = ctx.getContextualProperty("xfire.stax.input.factory");
        if (inFactoryObj instanceof XMLInputFactory) {
            return (XMLInputFactory)inFactoryObj;
        }
        if (inFactoryObj instanceof String) {
            String inFactory = (String)inFactoryObj;
            XMLInputFactory xif = (XMLInputFactory)factories.get(inFactory);
            if (xif == null) {
                xif = (XMLInputFactory)STAXUtils.createFactory(inFactory, ctx);
                STAXUtils.configureFactory(xif, ctx);
                factories.put(inFactory, xif);
            }
            return xif;
        }
        if (!inFactoryConfigured) {
            STAXUtils.configureFactory(xmlInputFactory, ctx);
            inFactoryConfigured = true;
        }
        return xmlInputFactory;
    }

    private static Boolean getBooleanProperty(MessageContext ctx, String name) {
        Object value = ctx.getContextualProperty(name);
        if (value != null) {
            return Boolean.valueOf(value.toString());
        }
        return null;
    }

    private static void configureFactory(XMLInputFactory xif, MessageContext ctx) {
        Boolean value = STAXUtils.getBooleanProperty(ctx, "javax.xml.stream.isValidating");
        if (value != null) {
            xif.setProperty("javax.xml.stream.isValidating", value);
        }
        if ((value = STAXUtils.getBooleanProperty(ctx, "javax.xml.stream.isNamespaceAware")) != null) {
            xif.setProperty("javax.xml.stream.isNamespaceAware", value);
        }
        if ((value = STAXUtils.getBooleanProperty(ctx, "javax.xml.stream.isCoalescing")) != null) {
            xif.setProperty("javax.xml.stream.isCoalescing", value);
        }
        if ((value = STAXUtils.getBooleanProperty(ctx, "javax.xml.stream.isReplacingEntityReferences")) != null) {
            xif.setProperty("javax.xml.stream.isReplacingEntityReferences", value);
        }
        if ((value = STAXUtils.getBooleanProperty(ctx, "javax.xml.stream.isSupportingExternalEntities")) != null) {
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", value);
        }
    }

    private static Object createFactory(String factory, MessageContext ctx) {
        Class factoryClass = null;
        try {
            factoryClass = ClassLoaderUtils.loadClass(factory, ctx.getClass());
            return factoryClass.newInstance();
        }
        catch (Exception e) {
            logger.error("Can't create factory for class : " + factory, e);
            throw new XFireRuntimeException("Can't create factory for class : " + factory);
        }
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in, String encoding, MessageContext ctx) {
        XMLInputFactory factory = STAXUtils.getXMLInputFactory(ctx);
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            return factory.createXMLStreamReader(in, encoding);
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(Reader reader) {
        return STAXUtils.createXMLStreamReader(reader, null);
    }

    public static XMLStreamReader createXMLStreamReader(Reader reader, MessageContext context) {
        XMLInputFactory factory = STAXUtils.getXMLInputFactory(context);
        try {
            return factory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    static {
        factories = new HashMap();
    }
}

