/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.test;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class XPathAssert {
    private static XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());

    public static List assertValid(String xpath, Object node, Map namespaces) throws Exception {
        if (node == null) {
            throw new NullPointerException("Node cannot be null.");
        }
        List nodes = XPathAssert.createXPath(xpath, namespaces).selectNodes(node);
        if (nodes.size() == 0) {
            String value = node instanceof Document ? outputter.outputString((Document)node) : (node instanceof Element ? outputter.outputString((Element)node) : node.toString());
            throw new AssertionFailedError("Failed to select any nodes for expression:.\n" + xpath + "\n" + value);
        }
        return nodes;
    }

    public static List assertInvalid(String xpath, Object node, Map namespaces) throws Exception {
        if (node == null) {
            throw new NullPointerException("Node cannot be null.");
        }
        List nodes = XPathAssert.createXPath(xpath, namespaces).selectNodes(node);
        if (nodes.size() > 0) {
            String value = node instanceof Document ? outputter.outputString((Document)node) : (node instanceof Element ? outputter.outputString((Element)node) : node.toString());
            throw new AssertionFailedError("Found multiple nodes for expression:\n" + xpath + "\n" + value);
        }
        return nodes;
    }

    public static void assertXPathEquals(String xpath, String value, Document node, Map namespaces) throws Exception {
        String value2 = null;
        Object valueNode = XPathAssert.createXPath(xpath, namespaces).selectSingleNode(node);
        if (valueNode instanceof Content) {
            value2 = ((Content)valueNode).getValue().trim();
        } else if (valueNode instanceof Attribute) {
            value2 = ((Attribute)valueNode).getValue().trim();
        }
        Assert.assertEquals((String)value, (String)value2);
    }

    public static void assertNoFault(Document node) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("s", Soap11.getInstance().getNamespace());
        namespaces.put("s12", Soap12.getInstance().getNamespace());
        XPathAssert.assertInvalid("/s:Envelope/s:Body/s:Fault", node, namespaces);
        XPathAssert.assertInvalid("/s12:Envelope/s12:Body/s12:Fault", node, namespaces);
    }

    public static void assertFault(Content node) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("s", Soap11.getInstance().getNamespace());
        namespaces.put("s12", Soap12.getInstance().getNamespace());
        XPathAssert.assertValid("/s:Envelope/s:Body/s:Fault", node, namespaces);
        XPathAssert.assertValid("/s12:Envelope/s12:Body/s12:Fault", node, namespaces);
    }

    public static XPath createXPath(String xpathString, Map namespaces) throws Exception {
        XPath xpath = XPath.newInstance(xpathString);
        Iterator itr = namespaces.keySet().iterator();
        while (itr.hasNext()) {
            String ns = (String)itr.next();
            xpath.addNamespace(ns, (String)namespaces.get(ns));
        }
        return xpath;
    }
}

