/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.tracer.client;

import de.fzj.unicore.uas.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.chemomentum.tracer.client.IMessageQuery;

public class TraceQueryDescription
implements Cloneable {
    public static final String TOTAL = String.valueOf(Long.MAX_VALUE);
    public static final int MODE_RESULT_SET = 0;
    public static final int MODE_SUM = 1;
    private IMessageQuery query;
    private List<String> attributes = new ArrayList<String>();
    private List<Pair<String, String>> boundaries = new ArrayList<Pair<String, String>>();
    private int mode;

    public TraceQueryDescription() {
    }

    public TraceQueryDescription(IMessageQuery query, int mode) {
        this(query, new ArrayList<String>(), "0", TOTAL, 0);
    }

    public TraceQueryDescription(IMessageQuery query, List<String> attributes, String first, String last, int mode) {
        this.query = query;
        this.attributes = attributes;
        this.mode = mode;
        this.boundaries.add(new Pair<String, String>(first, last));
    }

    public TraceQueryDescription(IMessageQuery query, List<String> attributes, List<Pair<String, String>> boundaries, int mode) {
        this.query = query;
        this.attributes = attributes;
        this.boundaries = boundaries;
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public IMessageQuery getQuery() {
        return this.query;
    }

    public void setQuery(IMessageQuery query) {
        this.query = query;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public Pair<String, String>[] getBoundaries() {
        return this.boundaries.toArray(new Pair[this.boundaries.size()]);
    }

    public void addBoundary(Pair<String, String> b) {
        this.boundaries.add(b);
    }

    public void addBoundary(Pair<String, String> b, int index) {
        this.boundaries.add(index, b);
    }

    public Pair<String, String> getBoundary(int index) {
        return this.boundaries.get(index);
    }

    public boolean removeBoundary(Pair<String, String> b) {
        int index = -1;
        int i = 0;
        while (i < this.boundaries.size()) {
            Pair<String, String> p = this.boundaries.get(i);
            if (b.getM1().equals(p.getM1()) && b.getM2().equals(p.getM2())) {
                index = i;
                break;
            }
            ++i;
        }
        return this.removeBoundary(index);
    }

    public boolean removeBoundary(int index) {
        if (index > -1 && index < this.boundaries.size()) {
            return this.boundaries.remove(index) != null;
        }
        return false;
    }

    public void removeAllBoundaries() {
        this.boundaries.clear();
    }

    public void setBoundaries(List<Pair<String, String>> boundaries) {
        this.boundaries = boundaries;
    }

    public TraceQueryDescription clone() {
        TraceQueryDescription result = null;
        try {
            result = (TraceQueryDescription)super.clone();
            result.attributes = new ArrayList<String>(this.attributes);
            result.boundaries = new ArrayList<Pair<String, String>>();
            for (Pair<String, String> p : this.boundaries) {
                result.addBoundary(new Pair<String, String>(p.getM1(), p.getM2()));
            }
            result.query = this.query.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

