/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.tracer.client;

import de.fzj.unicore.uas.client.BaseUASClient;
import eu.unicore.security.util.client.IClientProperties;
import java.math.BigInteger;
import org.chemomentum.common.ws.ITrace;
import org.chemomentum.tracer.client.QueryToOldXMLConverter;
import org.chemomentum.tracer.client.QueryToXMLConverter;
import org.chemomentum.tracer.client.TraceQueryDescription;
import org.chemomentum.tracer.xmlbeans.FilterEntriesRequestDocument;
import org.chemomentum.tracer.xmlbeans.FilterEntriesResponseDocument;
import org.chemomentum.tracer.xmlbeans.SendTraceRequestDocument;
import org.chemomentum.tracer.xmlbeans.TraceDocument;
import org.chemomentum.tracer.xmlbeans.TraceQueryDocument;
import org.chemomentum.tracer.xmlbeans.TracerPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TraceClient
extends BaseUASClient {
    public static final String SERVER_VERSION_6_2 = "1.2.0";
    public static final String SERVER_VERSION_6_3 = "1.3.0";
    private String serverVersion = null;

    public TraceClient(EndpointReferenceType epr, IClientProperties sp) throws Exception {
        super(epr.getAddress().getStringValue(), epr, sp);
    }

    public TraceDocument.Trace query(String field, String pattern) throws Exception {
        FilterEntriesRequestDocument ferd = FilterEntriesRequestDocument.Factory.newInstance();
        FilterEntriesRequestDocument.FilterEntriesRequest fer = ferd.addNewFilterEntriesRequest();
        fer.setField(field);
        fer.setPattern(pattern);
        FilterEntriesResponseDocument td = this.makeProxy(ITrace.class).filterEntries(ferd);
        if (td == null) {
            return null;
        }
        return td.getFilterEntriesResponse().getTrace();
    }

    public FilterEntriesResponseDocument query(TraceQueryDescription tpq) throws Exception {
        if (this.getServerVersion().compareTo(SERVER_VERSION_6_2) > 0) {
            TraceQueryDocument doc = QueryToXMLConverter.convert(tpq);
            return this.makeProxy(ITrace.class).query(doc);
        }
        FilterEntriesRequestDocument ferd = QueryToOldXMLConverter.convert(tpq);
        FilterEntriesResponseDocument result = this.makeProxy(ITrace.class).filterEntries(ferd);
        long numMessages = 0L;
        try {
            numMessages = result.getFilterEntriesResponse().getTrace().sizeOfEntryArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result.getFilterEntriesResponse().setNumberOfAvailableMessages(new BigInteger("" + numMessages));
        return result;
    }

    public void trace(SendTraceRequestDocument doc) throws Exception {
        this.makeProxy(ITrace.class).trace(doc);
    }

    @Override
    public String getServerVersion() {
        if (this.serverVersion != null) {
            return this.serverVersion;
        }
        try {
            this.serverVersion = this.getResourcePropertiesDocument().getTracerProperties().getVersion();
        }
        catch (Exception e) {
            this.serverVersion = SERVER_VERSION_6_2;
        }
        return this.serverVersion;
    }

    public TracerPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return TracerPropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }
}

