/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.impl.workflow;

import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.client.EnumerationClient;
import eu.unicore.security.util.Log;
import eu.unicore.security.util.client.IClientProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.chemomentum.common.api.IInfo;
import org.chemomentum.common.api.IResultReceiver;
import org.chemomentum.common.api.workflow.SubmitWFClient;
import org.chemomentum.common.api.workflow.WFClient;
import org.chemomentum.common.api.workflow.WorkflowWrapper;
import org.chemomentum.common.impl.workflow.InfoImpl;
import org.chemomentum.common.impl.workflow.WorkflowManagementClient;
import org.chemomentum.common.ws.IWorkflowFactory;
import org.chemomentum.workflow.xmlbeans.AccessibleWorkflowReferenceDocument;
import org.chemomentum.workflow.xmlbeans.CreateWorkflowResourceDocument;
import org.chemomentum.workflow.xmlbeans.CreateWorkflowResponseDocument;
import org.chemomentum.workflow.xmlbeans.WorkflowFactoryPropertiesDocument;
import org.chemomentum.workflow.xmlbeans.WorkflowReferenceDocument;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class WorkflowSubmissionClient
extends BaseUASClient
implements SubmitWFClient {
    private static final Logger logger = Log.getLogger((String)"unicore.client", WorkflowSubmissionClient.class);
    protected final IWorkflowFactory wssClient = this.makeProxy(IWorkflowFactory.class);

    public WorkflowSubmissionClient(String url, EndpointReferenceType epr, IClientProperties sec) throws Exception {
        super(url, epr, sec);
    }

    public WorkflowFactoryPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return WorkflowFactoryPropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public String[] getSupportedDialects() throws Exception {
        return this.getResourcePropertiesDocument().getWorkflowFactoryProperties().getSupportedDialectArray();
    }

    public List<EndpointReferenceType> getAccessibleWorkflowEPRs() throws Exception {
        EnumerationClient<WorkflowReferenceDocument> c = this.getWorkflowEnumeration();
        if (c == null) {
            return this.getAccessibleWorkflowsWithoutEnumeration();
        }
        ArrayList<EndpointReferenceType> res = new ArrayList<EndpointReferenceType>();
        Iterator<WorkflowReferenceDocument> iter = c.iterator();
        while (iter.hasNext()) {
            res.add(iter.next().getWorkflowReference());
        }
        return res;
    }

    public EnumerationClient<AccessibleWorkflowReferenceDocument> getAccessibleWorkflowEnumeration() throws Exception {
        EndpointReferenceType wfEnumEpr = this.getResourcePropertiesDocument().getWorkflowFactoryProperties().getAccessibleWorkflowEnumeration();
        if (wfEnumEpr != null) {
            EnumerationClient c = new EnumerationClient(wfEnumEpr, this.securityProperties, AccessibleWorkflowReferenceDocument.type.getDocumentElementName());
            return c;
        }
        return null;
    }

    public EnumerationClient<WorkflowReferenceDocument> getWorkflowEnumeration() throws Exception {
        EndpointReferenceType wfEnumEpr = this.getResourcePropertiesDocument().getWorkflowFactoryProperties().getWorkflowEnumeration();
        if (wfEnumEpr != null) {
            EnumerationClient c = new EnumerationClient(wfEnumEpr, this.securityProperties, WorkflowReferenceDocument.type.getDocumentElementName());
            return c;
        }
        return null;
    }

    @Override
    public void submit(WorkflowWrapper workflow, IResultReceiver<WFClient, IInfo> receiver) {
        try {
            WorkflowManagementClient wf = this.createWorkflow(workflow.getWorkflowName(), workflow.getTerminationTime(), workflow.getStorageAddress());
            wf.submitWorkflow(workflow);
            InfoImpl info = new InfoImpl(this);
            receiver.putResult(wf, info);
        }
        catch (Exception e) {
            Log.logException((String)"Error submitting", (Throwable)e, (Logger)logger);
            Object info = null;
            receiver.error(e, (IInfo)info);
        }
    }

    @Override
    public WorkflowManagementClient submitSynchronous(WorkflowWrapper workflow) throws Exception {
        WorkflowManagementClient wf = this.createWorkflow(workflow.getWorkflowName(), workflow.getTerminationTime(), workflow.getStorageAddress());
        wf.submitWorkflow(workflow);
        return wf;
    }

    @Override
    public WorkflowManagementClient createWorkflow() throws Exception {
        return this.createWorkflow(null, null, null);
    }

    public WorkflowManagementClient createWorkflow(String name, Calendar terminationTime) throws Exception {
        return this.createWorkflow(name, terminationTime, null);
    }

    public WorkflowManagementClient createWorkflow(String name, Calendar terminationTime, EndpointReferenceType storageEPR) throws Exception {
        CreateWorkflowResourceDocument create = CreateWorkflowResourceDocument.Factory.newInstance();
        create.addNewCreateWorkflowResource();
        if (name != null) {
            create.getCreateWorkflowResource().setWorkflowName(name);
        }
        if (terminationTime != null) {
            TerminationTimeDocument.TerminationTime tt = TerminationTimeDocument.TerminationTime.Factory.newInstance();
            tt.setCalendarValue(terminationTime);
            create.getCreateWorkflowResource().setTerminationTime(tt);
        }
        if (storageEPR != null) {
            create.getCreateWorkflowResource().setStorageEPR(storageEPR);
        }
        CreateWorkflowResponseDocument res = this.wssClient.create(create);
        EndpointReferenceType epr = res.getCreateWorkflowResponse().getEndpointReference();
        return new WorkflowManagementClient(epr.getAddress().getStringValue(), epr, this.getSecurityProperties());
    }

    private List<EndpointReferenceType> getAccessibleWorkflowsWithoutEnumeration() throws Exception {
        return Arrays.asList(this.getResourcePropertiesDocument().getWorkflowFactoryProperties().getAccessibleWorkflowReferenceArray());
    }
}

