/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.keyresolver.implementations.RSAKeyValueResolver;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class EncryptedKeyResolver
extends KeyResolverSpi {
    private static Log log = LogFactory.getLog(RSAKeyValueResolver.class);
    private Key kek;
    private String algorithm;

    public EncryptedKeyResolver(String algorithm) {
        this.kek = null;
        this.algorithm = algorithm;
    }

    public EncryptedKeyResolver(String algorithm, Key kek) {
        this.algorithm = algorithm;
        this.kek = kek;
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI2, StorageResolver storage) {
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI2, StorageResolver storage) {
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI2, StorageResolver storage) {
        SecretKey key;
        block6: {
            if (log.isDebugEnabled()) {
                log.debug("EncryptedKeyResolver - Can I resolve " + element.getTagName());
            }
            if (element == null) {
                return null;
            }
            key = null;
            boolean isEncryptedKey = XMLUtils.elementIsInEncryptionSpace(element, "EncryptedKey");
            if (isEncryptedKey) {
                if (log.isDebugEnabled()) {
                    log.debug("Passed an Encrypted Key");
                }
                try {
                    XMLCipher cipher = XMLCipher.getInstance();
                    cipher.init(4, this.kek);
                    EncryptedKey ek = cipher.loadEncryptedKey(element);
                    key = (SecretKey)cipher.decryptKey(ek, this.algorithm);
                }
                catch (XMLEncryptionException e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug(e);
                }
            }
        }
        return key;
    }
}

