/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound.factories;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.concurrent.ConcurrencyUtil;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.compound.CompoundStore;
import net.sf.ehcache.store.compound.ElementSubstitute;
import net.sf.ehcache.store.compound.ElementSubstituteFactory;
import net.sf.ehcache.store.compound.factories.FileAllocationTree;
import net.sf.ehcache.store.compound.factories.Region;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.util.MemoryEfficientByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DiskStorageFactory<T extends ElementSubstitute>
implements ElementSubstituteFactory<T> {
    protected static final String AUTO_DISK_PATH_DIRECTORY_PREFIX = "ehcache_auto_created";
    private static final int SERIALIZATION_CONCURRENCY_DELAY = 250;
    private static final int SHUTDOWN_GRACE_PERIOD = 60;
    private static final int MEGABYTE = 0x100000;
    private static final Logger LOG = LoggerFactory.getLogger(DiskStorageFactory.class.getName());
    protected volatile CompoundStore store;
    private final BlockingQueue<Runnable> diskQueue;
    private final ScheduledThreadPoolExecutor diskWriter;
    private final long queueCapacity;
    private final File file;
    private final RandomAccessFile[] dataAccess;
    private final FileAllocationTree allocator;
    private final RegisteredEventListeners eventService;
    private volatile int elementSize;

    DiskStorageFactory(File dataFile, long expiryInterval, long queueCapacity, RegisteredEventListeners eventService, final boolean daemonWriter, int stripes) {
        this.file = dataFile;
        try {
            this.dataAccess = DiskStorageFactory.allocateRandomAccessFiles(this.file, stripes);
        }
        catch (FileNotFoundException e) {
            throw new CacheException(e);
        }
        this.allocator = new FileAllocationTree(Long.MAX_VALUE, this.dataAccess[0]);
        this.diskWriter = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, DiskStorageFactory.this.file.getName());
                t.setDaemon(daemonWriter);
                return t;
            }
        });
        this.diskQueue = this.diskWriter.getQueue();
        this.eventService = eventService;
        this.queueCapacity = queueCapacity * 0x100000L;
        this.diskWriter.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.diskWriter.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.diskWriter.scheduleWithFixedDelay(new DiskExpiryTask(), expiryInterval, expiryInterval, TimeUnit.SECONDS);
    }

    private static RandomAccessFile[] allocateRandomAccessFiles(File f, int stripes) throws FileNotFoundException {
        int roundedStripes = stripes;
        while ((roundedStripes & roundedStripes - 1) != 0) {
            ++roundedStripes;
        }
        RandomAccessFile[] result = new RandomAccessFile[roundedStripes];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new RandomAccessFile(f, "rw");
        }
        return result;
    }

    private RandomAccessFile getDataAccess(Object key) {
        return this.dataAccess[ConcurrencyUtil.selectLock(key, this.dataAccess.length)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOnDiskSizeInBytes() {
        RandomAccessFile randomAccessFile = this.dataAccess[0];
        synchronized (randomAccessFile) {
            try {
                return this.dataAccess[0].length();
            }
            catch (IOException e) {
                LOG.warn("Exception trying to determine store size", e);
                return 0L;
            }
        }
    }

    @Override
    public void bind(CompoundStore store) {
        this.store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(Lock lock, ElementSubstitute substitute) {
        if (substitute instanceof DiskMarker) {
            DiskFreeTask free = new DiskFreeTask(lock, (DiskMarker)substitute);
            if (lock.tryLock()) {
                try {
                    free.call();
                }
                finally {
                    lock.unlock();
                }
            } else {
                this.schedule(free);
            }
        }
    }

    protected void markUsed(DiskMarker marker) {
        this.allocator.mark(new Region(marker.getPosition(), marker.getPosition() + (long)marker.getSize() - 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shrinkDataFile() {
        RandomAccessFile randomAccessFile = this.dataAccess[0];
        synchronized (randomAccessFile) {
            try {
                this.dataAccess[0].setLength(this.allocator.getFileSize());
            }
            catch (IOException e) {
                LOG.error("Exception trying to shrink data file to size", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() throws IOException {
        this.diskWriter.shutdown();
        for (int i = 0; i < 60; ++i) {
            try {
                if (this.diskWriter.awaitTermination(1L, TimeUnit.SECONDS)) break;
                LOG.info("Waited " + (i + 1) + " seconds for shutdown of [" + this.file.getName() + "]");
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn("Received exception while waiting for shutdown", e);
            }
        }
        RandomAccessFile[] arr$ = this.dataAccess;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RandomAccessFile raf;
            RandomAccessFile randomAccessFile = raf = arr$[i$];
            synchronized (randomAccessFile) {
                raf.close();
                continue;
            }
        }
    }

    protected void delete() {
        File dataDirectory;
        this.file.delete();
        this.allocator.clear();
        if (this.file.getAbsolutePath().contains(AUTO_DISK_PATH_DIRECTORY_PREFIX) && (dataDirectory = this.file.getParentFile()) != null && dataDirectory.exists() && dataDirectory.delete()) {
            LOG.debug("Deleted directory " + dataDirectory.getName());
        }
    }

    protected <U> Future<U> schedule(Callable<U> call) {
        return this.diskWriter.submit(call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element read(DiskMarker marker) throws IOException, ClassNotFoundException {
        RandomAccessFile data;
        byte[] buffer = new byte[marker.getSize()];
        RandomAccessFile randomAccessFile = data = this.getDataAccess(marker.getKey());
        synchronized (randomAccessFile) {
            data.seek(marker.getPosition());
            data.readFully(buffer);
        }
        ObjectInputStream objstr = new ObjectInputStream(new ByteArrayInputStream(buffer)){

            protected Class resolveClass(ObjectStreamClass clazz) throws ClassNotFoundException, IOException {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return Class.forName(clazz.getName(), false, classLoader);
                }
                catch (ClassNotFoundException e) {
                    return super.resolveClass(clazz);
                }
            }
        };
        try {
            Element element = (Element)objstr.readObject();
            return element;
        }
        finally {
            objstr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiskMarker write(Element element) throws IOException {
        RandomAccessFile data;
        int bufferLength;
        Element elementToSerialize = element;
        if (element.getObjectValue() instanceof SoftLock) {
            elementToSerialize = null;
        }
        MemoryEfficientByteArrayOutputStream buffer = this.serializeElement(elementToSerialize);
        this.elementSize = bufferLength = buffer.size();
        DiskMarker marker = this.alloc(element, bufferLength);
        RandomAccessFile randomAccessFile = data = this.getDataAccess(element.getObjectKey());
        synchronized (randomAccessFile) {
            data.seek(marker.getPosition());
            data.write(buffer.toByteArray(), 0, bufferLength);
        }
        return marker;
    }

    private MemoryEfficientByteArrayOutputStream serializeElement(Element element) throws IOException {
        ConcurrentModificationException exception = null;
        for (int retryCount = 0; retryCount < 2; ++retryCount) {
            try {
                return MemoryEfficientByteArrayOutputStream.serialize(element);
            }
            catch (ConcurrentModificationException e) {
                exception = e;
                try {
                    TimeUnit.MILLISECONDS.sleep(250L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        throw exception;
    }

    private DiskMarker alloc(Element element, int size) throws IOException {
        Region r = this.allocator.alloc(size);
        return this.createMarker(r.start(), size, element);
    }

    protected abstract DiskMarker createMarker(long var1, int var3, Element var4);

    protected void free(DiskMarker marker) {
        this.allocator.free(new Region(marker.getPosition(), marker.getPosition() + (long)marker.getSize() - 1L));
    }

    public boolean bufferFull() {
        return (long)(this.diskQueue.size() * this.elementSize) > this.queueCapacity;
    }

    public File getDataFile() {
        return this.file;
    }

    public void expireElements() {
        new DiskExpiryTask().run();
    }

    private final class DiskExpiryTask
    implements Runnable {
        private DiskExpiryTask() {
        }

        public void run() {
            long now = System.currentTimeMillis();
            for (Object key : DiskStorageFactory.this.store.keySet()) {
                Object value = DiskStorageFactory.this.store.unretrievedGet(key);
                if (!DiskStorageFactory.this.created(value) || !(value instanceof DiskMarker)) continue;
                this.checkExpiry((DiskMarker)value, now);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void checkExpiry(DiskMarker marker, long now) {
            if (marker.getExpirationTime() >= now) return;
            if (DiskStorageFactory.this.eventService.hasCacheEventListeners()) {
                try {
                    Element element = DiskStorageFactory.this.read(marker);
                    if (!DiskStorageFactory.this.store.evict(marker.getKey(), marker)) return;
                    DiskStorageFactory.this.eventService.notifyElementExpiry(element, false);
                    return;
                }
                catch (Exception e) {
                    return;
                }
            } else {
                DiskStorageFactory.this.store.evict(marker.getKey(), marker);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class DiskMarker
    extends DiskSubstitute
    implements Serializable {
        private final Object key;
        private final long position;
        private final int size;
        private final long hitCount;

        DiskMarker(DiskStorageFactory<? extends ElementSubstitute> factory, long position, int size, Element element) {
            super(factory);
            this.position = position;
            this.size = size;
            this.key = element.getObjectKey();
            this.hitCount = element.getHitCount();
        }

        DiskMarker(DiskStorageFactory<? extends ElementSubstitute> factory, long position, int size, Object key, long hits) {
            super(factory);
            this.position = position;
            this.size = size;
            this.key = key;
            this.hitCount = hits;
        }

        @Override
        Object getKey() {
            return this.key;
        }

        @Override
        long getHitCount() {
            return this.hitCount;
        }

        private long getPosition() {
            return this.position;
        }

        private int getSize() {
            return this.size;
        }

        @Override
        public void installed() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Placeholder
    extends DiskSubstitute {
        private final Object key;
        private final Element element;

        Placeholder(DiskStorageFactory<ElementSubstitute> factory, Element element) {
            super(factory);
            this.key = element.getObjectKey();
            this.element = element;
        }

        @Override
        Object getKey() {
            return this.key;
        }

        @Override
        long getHitCount() {
            return this.getElement().getHitCount();
        }

        @Override
        long getExpirationTime() {
            return this.getElement().getExpirationTime();
        }

        Element getElement() {
            return this.element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class DiskSubstitute
    implements ElementSubstitute {
        private volatile transient DiskStorageFactory<? extends ElementSubstitute> factory;

        public DiskSubstitute() {
            this.factory = null;
        }

        DiskSubstitute(DiskStorageFactory<? extends ElementSubstitute> factory) {
            this.factory = factory;
        }

        abstract Object getKey();

        abstract long getHitCount();

        abstract long getExpirationTime();

        public final DiskStorageFactory<ElementSubstitute> getFactory() {
            return this.factory;
        }

        void bindFactory(DiskStorageFactory<? extends ElementSubstitute> factory) {
            this.factory = factory;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DiskFreeTask
    implements Callable<Void> {
        private final Lock lock;
        private final DiskMarker marker;

        private DiskFreeTask(Lock lock, DiskMarker marker) {
            this.lock = lock;
            this.marker = marker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            this.lock.lock();
            try {
                DiskStorageFactory.this.free(this.marker);
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class DiskWriteTask
    implements Callable<DiskMarker> {
        private final Placeholder placeholder;

        DiskWriteTask(Placeholder p) {
            this.placeholder = p;
        }

        Placeholder getPlaceholder() {
            return this.placeholder;
        }

        @Override
        public DiskMarker call() {
            try {
                DiskMarker marker = DiskStorageFactory.this.write(this.placeholder.getElement());
                if (DiskStorageFactory.this.store.fault(this.placeholder.getKey(), this.placeholder, marker)) {
                    return marker;
                }
                return null;
            }
            catch (IOException e) {
                LOG.error("Disk Write of " + this.placeholder.getKey() + " failed (it will be evicted instead): ", e);
                DiskStorageFactory.this.store.evict(this.placeholder.getKey(), this.placeholder);
                return null;
            }
        }
    }
}

