/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.dpc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Utils {
    private static final String algo = "Blowfish";
    private static final String keyAlgo = "DES";
    private static final String mode = "ECB";
    private static final String padding = "PKCS7Padding";
    private static KeyGenerator keyGenerator;
    private static final ScheduledExecutorService executor;
    private static Set<String> whiteList;

    public static InputStream getDecryptStream(InputStream source, byte[] key) throws IOException {
        try {
            return new CipherInputStream(source, Utils.makeDecryptionCipher(key));
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static OutputStream getEncryptStream(OutputStream sink, byte[] key) throws IOException {
        try {
            return new CipherOutputStream(sink, Utils.makeEncryptionCipher(key));
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static String encodeBase64(byte[] data) {
        if (data == null) {
            return null;
        }
        return new String(Base64.encodeBase64(data));
    }

    public static byte[] decodeBase64(String base64) {
        if (base64 == null) {
            return null;
        }
        return Base64.decodeBase64(base64.getBytes());
    }

    public static Cipher makeEncryptionCipher(byte[] encodedKey) throws Exception {
        Cipher c = Cipher.getInstance("Blowfish/ECB/PKCS7Padding", "BC");
        SecretKeySpec keySpec = new SecretKeySpec(encodedKey, keyAlgo);
        SecretKey key = SecretKeyFactory.getInstance(keyAlgo, "BC").generateSecret(keySpec);
        c.init(1, key);
        return c;
    }

    public static Cipher makeDecryptionCipher(byte[] encodedKey) throws Exception {
        Cipher c = Cipher.getInstance("Blowfish/ECB/PKCS7Padding", "BC");
        SecretKeySpec keySpec = new SecretKeySpec(encodedKey, keyAlgo);
        SecretKey key = SecretKeyFactory.getInstance(keyAlgo, "BC").generateSecret(keySpec);
        c.init(2, key);
        return c;
    }

    public static byte[] createKey() throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        SecretKey key = keyGenerator.generateKey();
        return key.getEncoded();
    }

    public static String md5(File file) throws Exception {
        return Utils.hexString(Utils.digest(file));
    }

    public static String md5(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data);
            return Utils.hexString(md);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static MessageDigest digest(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        byte[] buf = new byte[1024];
        int r = 0;
        MessageDigest md = MessageDigest.getInstance("MD5");
        while ((r = fis.read(buf)) >= 0) {
            md.update(buf, 0, r);
        }
        fis.close();
        return md;
    }

    private static String hexString(MessageDigest digest) {
        byte[] messageDigest = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < messageDigest.length; ++i) {
            String hex = Integer.toHexString(0xFF & messageDigest[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static ScheduledExecutorService getExecutor() {
        return executor;
    }

    public static synchronized Set<String> getWhiteList() {
        if (whiteList == null) {
            whiteList = new HashSet<String>();
        }
        return whiteList;
    }

    public static String getDetailMessage(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        Throwable cause = throwable;
        String message = null;
        String type = null;
        type = cause.getClass().getName();
        do {
            type = cause.getClass().getName();
            message = cause.getMessage();
        } while ((cause = cause.getCause()) != null);
        sb.append(type).append(" ");
        if (message != null) {
            sb.append(message);
        } else {
            sb.append(" (no further message available)");
        }
        return sb.toString();
    }

    public static String createFaultMessage(String message, Throwable cause) {
        return message + ": " + Utils.getDetailMessage(cause);
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
        try {
            keyGenerator = KeyGenerator.getInstance(keyAlgo, "BC");
            keyGenerator.init(new SecureRandom());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        executor = new ScheduledThreadPoolExecutor(10);
    }
}

