/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil.client;

import eu.unicore.security.xfireutil.client.CheckUnderstoodHeadersHandler;
import eu.unicore.security.xfireutil.client.HttpMessageSender;
import eu.unicore.security.xfireutil.client.JSR181ServiceFactory;
import eu.unicore.security.xfireutil.client.LogInMessageHandler;
import eu.unicore.security.xfireutil.client.LogOutMessageHandler;
import eu.unicore.security.xfireutil.client.ReliableProxy;
import eu.unicore.security.xfireutil.client.ReliableProxyFactory;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.HttpUtils;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.http.HttpChannel;

public class XFireClientFactory {
    protected static final Logger logger = Log.getLogger("unicore.client", XFireClientFactory.class);
    public static final String GZIP_ENABLE = "http.gzipEnable";
    public static final String LOG_INCOMING = "log.incoming";
    public static final String LOG_OUTGOING = "log.outgoing";
    protected final DefaultXFire xfire;
    protected final ReliableProxyFactory proxyMaker;
    protected IClientConfiguration securityProperties;
    protected Properties settings;
    protected ServiceFactory factory;
    protected List<Handler> inHandlers;
    protected List<Handler> outHandlers;
    protected List<Handler> faultHandlers;

    public XFireClientFactory(IClientConfiguration sec) {
        this(new JSR181ServiceFactory(), sec);
    }

    public XFireClientFactory(ServiceFactory serviceFactory) {
        this(serviceFactory, new DefaultClientConfiguration());
    }

    public XFireClientFactory(ServiceFactory serviceFactory, IClientConfiguration securityCfg) {
        if (serviceFactory == null) {
            throw new IllegalArgumentException("Service Factory can not be null");
        }
        if (securityCfg == null) {
            throw new IllegalArgumentException("IAuthenticationConfiguration can not be null");
        }
        if (securityCfg.getExtraSettings() == null) {
            throw new IllegalArgumentException("Properties can not be null");
        }
        this.factory = serviceFactory;
        this.xfire = (DefaultXFire)XFireFactory.newInstance().getXFire();
        this.proxyMaker = new ReliableProxyFactory();
        this.securityProperties = securityCfg.clone();
        this.settings = securityCfg.getExtraSettings();
        this.initHandlers();
    }

    protected void initHandlers() {
        this.faultHandlers = new ArrayList<Handler>();
        this.inHandlers = new ArrayList<Handler>();
        if ("true".equals(this.settings.getProperty(LOG_INCOMING))) {
            this.inHandlers.add(new LogInMessageHandler());
        }
        this.inHandlers.add(new CheckUnderstoodHeadersHandler());
        this.outHandlers = new ArrayList<Handler>();
        if ("true".equals(this.settings.getProperty(LOG_OUTGOING))) {
            this.outHandlers.add(new LogOutMessageHandler());
        }
        this.outHandlers.add(new CheckUnderstoodHeadersHandler());
    }

    public synchronized <T> T createPlainWSProxy(Class<T> iFace, String url) throws MalformedURLException {
        Service serviceModel = this.isLocal(url) ? this.getLocalService(url) : this.factory.create(iFace);
        Object proxy = this.proxyMaker.create(serviceModel, url);
        this.doAddHandlers(proxy);
        this.setupProxy(proxy, this.securityProperties, this.settings, url);
        this.setupProxyInterface(iFace, XFireClientFactory.getXfireClient(proxy), this.securityProperties, this.settings);
        return (T)proxy;
    }

    protected <T> void setupProxyInterface(Class<T> iFace, Client xfireClient, IClientConfiguration cnf, Properties properties) {
    }

    public Client createDynamicClient(String url) throws Exception {
        String wsdl = this.getServiceWSDL(url, this.securityProperties);
        Client client = new Client(new ByteArrayInputStream(wsdl.getBytes()), null);
        client.setUrl(url);
        logger.debug("Client created:\nService Name: " + client.getService().getSimpleName() + "\n" + "Service URL: " + client.getUrl() + "\n");
        this.setupProxy(client, this.securityProperties, this.settings, url);
        return client;
    }

    protected void doAddHandlers(Object proxy) {
        List<Handler> l3;
        List<Handler> l2;
        Client client = XFireClientFactory.getXfireClient(proxy);
        client.setProperty("messageSender.className", HttpMessageSender.class.getName());
        List<Handler> l = this.getOutHandlers();
        if (l != null) {
            for (Handler h : l) {
                client.addOutHandler(h);
            }
        }
        if ((l2 = this.getInHandlers()) != null) {
            for (Handler h : l2) {
                client.addInHandler(h);
            }
        }
        if ((l3 = this.getFaultHandlers()) != null) {
            for (Handler h : l3) {
                client.addFaultHandler(h);
            }
        }
    }

    protected List<Handler> getOutHandlers() {
        return this.outHandlers;
    }

    protected List<Handler> getInHandlers() {
        return this.inHandlers;
    }

    protected List<Handler> getFaultHandlers() {
        return this.faultHandlers;
    }

    protected Service getLocalService(String url) {
        try {
            String serviceName = new URI(url).getHost();
            return this.xfire.getServiceRegistry().getService(serviceName);
        }
        catch (Exception mue) {
            return null;
        }
    }

    protected boolean isLocal(String url) {
        if (url == null) {
            return false;
        }
        return url.startsWith("xfire.local://");
    }

    protected void setupProxy(Client xfireClient, IClientConfiguration cnf, Properties properties, String uri) {
        Channel channel = xfireClient.getOutChannel();
        if (cnf.doHttpAuthn()) {
            xfireClient.setProperty("username", cnf.getHttpUser());
            xfireClient.setProperty("password", cnf.getHttpPassword());
        }
        if (!this.isLocal(uri)) {
            if (!(channel instanceof HttpChannel)) {
                throw new IllegalStateException("Can't configure non HTTP channel - it is unsupported. Current channel is: " + channel.getClass());
            }
            HttpChannel httpChannel = (HttpChannel)channel;
            HttpClient httpClient = HttpUtils.createClient(properties);
            httpChannel.setProperty("httpClient", httpClient);
            HttpUtils.configureSSL(httpClient, cnf);
            if (uri != null) {
                HttpUtils.configureProxy(httpClient, uri, properties);
            }
            boolean gzipEnabled = Boolean.parseBoolean(properties.getProperty(GZIP_ENABLE, "true"));
            httpChannel.setProperty("gzip.enabled", gzipEnabled);
            String noKeepAlive = properties.getProperty("http.disable-keep-alive", "true");
            xfireClient.setProperty("disable-keep-alive", noKeepAlive);
        }
    }

    protected void setupProxy(Object proxy, IClientConfiguration cnf, Properties properties, String uri) {
        this.setupProxy(XFireClientFactory.getXfireClient(proxy), cnf, properties, uri);
    }

    public static Client getXfireClient(Object proxy) {
        try {
            ReliableProxy xp = (ReliableProxy)Proxy.getInvocationHandler(proxy);
            return xp.getClient();
        }
        catch (IllegalArgumentException iae) {
            return Client.getInstance(proxy);
        }
        catch (ClassCastException cce) {
            return Client.getInstance(proxy);
        }
    }

    protected String getServiceWSDL(String url, IClientConfiguration sec) throws Exception {
        HttpClient client = HttpUtils.createClient(url, sec);
        String wsdlurl = url + "?wsdl";
        GetMethod method = new GetMethod(wsdlurl);
        client.executeMethod(method);
        return method.getResponseBodyAsString();
    }
}

