/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.SAMLUtils;
import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.exceptions.SAMLRequestException;
import eu.unicore.samly2.exceptions.SAMLVersionException;
import eu.unicore.samly2.proto.AbstractSAMLMessage;
import eu.unicore.security.dsig.DSigException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import xmlbeans.org.oasis.saml2.protocol.ExtensionsType;
import xmlbeans.org.oasis.saml2.protocol.RequestAbstractType;

public abstract class AbstractRequest
extends AbstractSAMLMessage {
    protected RequestAbstractType xmlReq;

    protected AbstractRequest() {
    }

    protected AbstractRequest(RequestAbstractType src) {
        this.xmlReq = src;
    }

    protected void init(RequestAbstractType src, NameID issuer) {
        this.xmlReq = src;
        this.xmlReq.setIssuer(issuer.getXBean());
        this.xmlReq.setIssueInstant(Calendar.getInstance());
        this.xmlReq.setID(this.genID());
        this.xmlReq.setVersion("2.0");
    }

    public void parse() throws SAMLProtocolException {
        if (this.xmlReq.getVersion() == null) {
            throw new SAMLVersionException(null, "No SAML version is set");
        }
        String ver = this.xmlReq.getVersion();
        if (!ver.equals("2.0")) {
            throw new SAMLVersionException(null, "Only SAML 2.0 version is supported");
        }
        if (this.xmlReq.getID() == null) {
            throw new SAMLRequestException(null, "No ID is set");
        }
        if (this.xmlReq.getIssueInstant() == null) {
            throw new SAMLRequestException(null, "No IssueInstant is set");
        }
    }

    public String getID() {
        return this.xmlReq.getID();
    }

    public NameID getIssuer() {
        return new NameID(this.xmlReq.getIssuer());
    }

    public XmlObject getXMLBean() {
        return this.xmlReq;
    }

    public ExtensionsType getExtensions() {
        return this.xmlReq.getExtensions();
    }

    public void setExtensions(XmlObject ext) {
        ExtensionsType exts = this.xmlReq.addNewExtensions();
        exts.set(ext);
    }

    @Override
    public Document getDOM() throws DSigException {
        return SAMLUtils.getDOM(this.getDoc());
    }

    @Override
    public boolean isSigned() {
        return this.xmlReq.getSignature() != null && !this.xmlReq.getSignature().isNil();
    }

    @Override
    public X509Certificate[] getIssuerFromSignature() {
        return SAMLUtils.getIssuerFromSignature(this.xmlReq.getSignature());
    }
}

