/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6.util;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.ProtocolType;

public class FileTransfers {
    private static final String KEY_TRANSFERPREFS = "transferprefs";
    private static final Logger log = Logger.getLogger(FileTransfers.class);

    public static void getDefaultUftpParameters(Map<String, String> extraParameters) {
        String streams;
        String host = extraParameters.get("uftp.client.host");
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
                extraParameters.put("uftp.client.host", host);
            }
            catch (Exception e) {
                log.error("Unable to determine local hostname for UFTP transfer.");
            }
        }
        if ((streams = extraParameters.get("uftp.streams")) == null) {
            extraParameters.put("uftp.streams", "2");
        }
    }

    public static ProtocolType.Enum[] getFTPrefs() {
        ArrayList<ProtocolType.Enum> transferPrefs = new ArrayList<ProtocolType.Enum>();
        Preferences prefs = Preferences.userNodeForPackage(FileTransfers.class);
        try {
            prefs.sync();
        }
        catch (BackingStoreException e1) {
            log.warn("Unable to read preferences.", e1);
        }
        String rawPrefs = prefs.get(KEY_TRANSFERPREFS, "BFT RBYTEIO");
        prefs.put(KEY_TRANSFERPREFS, rawPrefs);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            log.warn("Unable to persist preferences.", e);
        }
        StringTokenizer tok = new StringTokenizer(rawPrefs);
        while (tok.hasMoreTokens()) {
            String curTok = tok.nextToken();
            ProtocolType.Enum type = ProtocolType.Enum.forString(curTok);
            if (type == null) continue;
            transferPrefs.add(type);
        }
        return transferPrefs.toArray(new ProtocolType.Enum[transferPrefs.size()]);
    }
}

