/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6.security;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.grid.Config;
import eu.unicore.hila.grid.ID;
import eu.unicore.hila.grid.unicore6.Unicore6Properties;
import eu.unicore.hila.grid.unicore6.Unicore6SecurityProperties;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.security.etd.TrustDelegation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class TDConfig
implements Config {
    private static final Logger log = Logger.getLogger(TDConfig.class);
    private final Unicore6Properties props;
    private final File samlRepo;

    public TDConfig(Unicore6Properties _props) {
        this.props = _props;
        this.samlRepo = new File(new File(System.getProperty("user.home"), ".hila2"), "saml-assertions");
        this.samlRepo.mkdirs();
    }

    public List<Location> getAllSiteLocations() throws HiLANotImplementedException {
        throw new HiLANotImplementedException("getAllSiteLocations not implemented");
    }

    public ID getIdForLocation(Location location) throws HiLAException {
        return this.determineSecurityProperties(location);
    }

    public void setIdForLocation(Location location, ID id) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Unicore6SecurityProperties determineSecurityProperties(Location location) throws HiLAException {
        String profile = location.getUser();
        Unicore6SecurityProperties u6secProp = new Unicore6SecurityProperties(this.props);
        File samlFile = new File(this.samlRepo, profile);
        if (!samlFile.exists()) throw new HiLAException("No SAML assertion for profile " + profile);
        if (log.isDebugEnabled()) {
            log.debug("Reading SAML assertion from " + samlFile);
        }
        try {
            AssertionDocument ad = AssertionDocument.Factory.parse(samlFile);
            TrustDelegation td = new TrustDelegation(ad);
            List<TrustDelegation> tdList = u6secProp.getETDSettings().getTrustDelegationTokens();
            if (tdList == null) {
                tdList = new ArrayList<TrustDelegation>();
            }
            tdList.add(td);
            u6secProp.getETDSettings().setTrustDelegationTokens(tdList);
            if (log.isDebugEnabled()) {
                log.debug("Set trust delegation on securityProperties.");
            }
        }
        catch (XmlException e) {
            throw new HiLAException("Invalid SAML assertion for profile " + profile, (Throwable)e);
        }
        catch (IOException e) {
            throw new HiLAException("Unable to read SAML assertion for profile " + profile, (Throwable)e);
        }
        catch (SAMLParseException e) {
            throw new HiLAException("SAML parsing failed for profile " + profile, (Throwable)e);
        }
        u6secProp.toString();
        return u6secProp;
    }
}

