/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.unicore6.StorageLocator;
import eu.unicore.hila.grid.unicore6.Unicore6Grid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@ResourceType(locationStructure={"unicore6:/storages/?", "unicore6:/{user}@storages/?", "unicore6:/sites/{siteName}/storages/?", "unicore6:/{user}@sites/{siteName}/storages/?"})
public class Unicore6StoragesCollection
extends BaseResource {
    public Unicore6StoragesCollection(Location location) {
        super(location);
    }

    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> storages = new ArrayList<Resource>();
        Resource parent = this.getParent();
        if (parent instanceof Site) {
            Site site = (Site)parent;
            storages.addAll(site.getStorages());
        } else if (parent instanceof Job) {
            Job task = (Job)parent;
            storages.add((Resource)task.getWorkingDirectory().getStorage());
        } else if (parent instanceof Unicore6Grid) {
            Unicore6Grid grid = (Unicore6Grid)parent;
            storages.addAll(this.discoverGlobalStorages(grid));
        } else {
            throw new HiLAException("Cannot determine what kind of storages you're looking for.");
        }
        return storages;
    }

    private Collection<? extends Resource> discoverGlobalStorages(Unicore6Grid grid) throws HiLAException {
        List<String> registryURLs = grid.getProperties().getRegistryUrls();
        return StorageLocator.getInstance().getAllStorages(registryURLs, grid.getProperties(), 5000L, this.getLocation());
    }
}

