/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.common.grid.BaseSimpleTransfer;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.grid.unicore6.util.FileTransfers;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class Unicore6ImportFromStreamTask
extends BaseSimpleTransfer
implements SimpleTransfer,
Callable<TaskStatus> {
    private final Future<TaskStatus> transferFuture;
    private final StorageClient storageClient;
    private final String path;
    private final InputStream is;

    public Unicore6ImportFromStreamTask(Location _location, StorageClient _storageClient, String _path, InputStream _is) throws HiLAException {
        super(_location.getChildLocation("imports").getChildLocation(UUID.randomUUID().toString()));
        this.setCurrentState(TaskStatus.NEW);
        this.storageClient = _storageClient;
        this.path = _path;
        this.is = _is;
        this.transferFuture = HiLA.getExecutor().submit(this);
    }

    public void abort() throws HiLAException {
        this.transferFuture.cancel(true);
        this.setCurrentState(TaskStatus.ABORTED);
    }

    public String getId() throws HiLAException {
        return this.getName();
    }

    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> children = new ArrayList<Resource>();
        return children;
    }

    @Override
    public TaskStatus call() throws Exception {
        this.setCurrentState(TaskStatus.RUNNING);
        try {
            HashMap<String, String> extraParameters = new HashMap<String, String>();
            FileTransfers.getDefaultUftpParameters(extraParameters);
            FileTransferClient ftc = this.storageClient.getImport(this.path, false, extraParameters, FileTransfers.getFTPrefs());
            ftc.writeAllData(this.is);
            this.setCurrentState(TaskStatus.SUCCESSFUL);
        }
        catch (IOException e) {
            HiLAException e2 = new HiLAException("Unable to import file.", (Throwable)e);
            this.setCurrentState(TaskStatus.FAILED, e2);
            throw e2;
        }
        catch (Exception e) {
            HiLAException e2 = new HiLAException("Unable to import file.", (Throwable)e);
            this.setCurrentState(TaskStatus.FAILED, e2);
            throw e2;
        }
        return this.status();
    }
}

