/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import eu.unicore.hila.Location;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseFile;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.Grid;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.Storage;
import eu.unicore.hila.grid.ThirdPartyTransfer;
import eu.unicore.hila.grid.unicore6.Unicore6ExportTask;
import eu.unicore.hila.grid.unicore6.Unicore6ExportToStreamTask;
import eu.unicore.hila.grid.unicore6.Unicore6Grid;
import eu.unicore.hila.grid.unicore6.Unicore6ImportFromStreamTask;
import eu.unicore.hila.grid.unicore6.Unicore6ImportTask;
import eu.unicore.hila.grid.unicore6.Unicore6RecursiveExportTask;
import eu.unicore.hila.grid.unicore6.Unicore6RecursiveImportTask;
import eu.unicore.hila.grid.unicore6.Unicore6RecursiveTransferTask;
import eu.unicore.hila.grid.unicore6.Unicore6Storage;
import eu.unicore.hila.grid.unicore6.Unicore6TransferTask;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.PermissionsType;

@ResourceType(locationStructure={"unicore6:/sites/{site}/storages/{storage}/files((/?)|(/.*))", "unicore6:/{user}@sites/{site}/storages/{storage}/files((/?)|(/.*))", "unicore6:/sites/{site}/tasks/{task}/wd/files((/?)|(/.*))", "unicore6:/{user}@sites/{site}/tasks/{task}/wd/files((/?)|(/.*))", "unicore6:/storages/{storage}/files((/?)|(/.*))", "unicore6:/{user}@storages/{storage}/files((/?)|(/.*))"})
public class Unicore6File
extends BaseFile
implements File {
    private static final Logger log = Logger.getLogger(Unicore6File.class);
    private static final Map<Location, Unicore6File> fileMap = new HashMap<Location, Unicore6File>();
    private static final CharSequence REASON_FILENOTFOUND = "Reason: java.io.FileNotFoundException";
    private StorageClient storageClient = null;
    private Unicore6Storage storage = null;
    private String decodedPath = null;
    private GridFileType gridFile = null;
    private long gridFileTimeStamp = 0L;

    private Unicore6File(Location _location, StorageClient _storageClient, GridFileType _gridFile) throws HiLAException {
        super(_location);
        this.storageClient = _storageClient;
        this.gridFile = _gridFile;
        this.gridFileTimeStamp = System.currentTimeMillis();
        Location storageLocation = Unicore6File.findParentLocationOfType(Unicore6Storage.class, (Location)_location, Unicore6Grid.class);
        try {
            this.storage = (Unicore6Storage)storageLocation.locate(new Object[0]);
            if (this.storageClient == null) {
                this.storageClient = this.storage.getStorageClient();
            }
        }
        catch (HiLAException e) {
            log.error("Couldn't locate storage");
        }
        this.path = storageLocation.getChildLocation("files").relativePath(_location);
        this.decodedPath = this.decode(this.path);
    }

    public static synchronized Unicore6File locate(Location _location, Object ... _extraInformation) throws HiLAException {
        if (fileMap.containsKey(_location)) {
            Unicore6File file = fileMap.get(_location);
            for (Object object : _extraInformation) {
                if (!(object instanceof GridFileType)) continue;
                file.gridFile = (GridFileType)object;
                file.gridFileTimeStamp = System.currentTimeMillis();
            }
            return file;
        }
        StorageClient storageClient = null;
        GridFileType gridFile = null;
        for (Object object : _extraInformation) {
            if (object instanceof StorageClient) {
                storageClient = (StorageClient)object;
            }
            if (!(object instanceof GridFileType)) continue;
            gridFile = (GridFileType)object;
        }
        Unicore6File file = new Unicore6File(_location, storageClient, gridFile);
        fileMap.put(_location, file);
        return file;
    }

    public boolean delete(boolean _recursive) throws HiLAException {
        if (this.isDirectory() && !_recursive) {
            throw new HiLAException("Cannot delete directory without recursion.");
        }
        if (this.storageClient != null) {
            try {
                this.storageClient.delete(this.decodedPath);
                this.gridFileTimeStamp = 0L;
                return true;
            }
            catch (BaseFault e) {
                if (e.getMessage().contains(REASON_FILENOTFOUND)) {
                    throw new HiLAException("File not found.", (Throwable)e);
                }
                throw new HiLAException("Error while deleting file.");
            }
        }
        return false;
    }

    public boolean exists() throws HiLAException {
        if (this.storageClient == null) {
            if (this.storage != null) {
                this.storageClient = this.storage.getStorageClient();
            } else {
                throw new HiLAException("No access to storage.");
            }
        }
        if (this.storageClient != null) {
            try {
                this.gridFile = this.storageClient.listProperties(this.decodedPath);
                return true;
            }
            catch (BaseFault e) {
                if (e.getMessage().contains(REASON_FILENOTFOUND)) {
                    return false;
                }
                throw new HiLAException("Couldn't determine whether file exists.", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public long size() throws HiLAException {
        this.updateGridFile();
        return this.gridFile.getSize();
    }

    public Storage getStorage() {
        return this.storage;
    }

    public SimpleTransfer importFromLocalFile(java.io.File localFile, boolean _overwrite, boolean _recursive) throws HiLAException {
        Unicore6ImportTask _import;
        Location storageLocation = Unicore6File.findParentLocationOfType(Storage.class, (Location)this.location, Grid.class);
        Unicore6File importFile = null;
        importFile = this.exists() && this.isDirectory() ? (Unicore6File)this.getChild(localFile.getName()) : this;
        if (localFile.isDirectory() && _recursive) {
            importFile.mkdir();
            _import = new Unicore6RecursiveImportTask(localFile, importFile);
        } else {
            _import = new Unicore6ImportTask(storageLocation, importFile.storageClient, importFile.decodedPath, importFile, localFile, _overwrite);
        }
        return _import;
    }

    public SimpleTransfer exportToLocalFile(java.io.File localFile, boolean _overwrite, boolean _recursive) throws HiLAException {
        Location storageLocation = Unicore6File.findParentLocationOfType(Storage.class, (Location)this.location, Grid.class);
        if (localFile.exists() && localFile.isDirectory()) {
            localFile = new java.io.File(localFile, this.getName());
        }
        Unicore6ExportTask export = this.isDirectory() && _recursive ? new Unicore6RecursiveExportTask(this, localFile) : new Unicore6ExportTask(storageLocation, this.storageClient, this.decodedPath, this, localFile, _overwrite);
        return export;
    }

    public boolean isDirectory() throws HiLAException {
        this.updateGridFile();
        return this.gridFile.getIsDirectory();
    }

    public List<File> ls() throws HiLAException {
        if (this.storageClient == null) {
            if (this.storage != null) {
                this.storageClient = this.storage.getStorageClient();
            } else {
                throw new HiLAException("No access to storage.");
            }
        }
        if (this.isDirectory()) {
            ArrayList<File> children = new ArrayList<File>();
            try {
                GridFileType[] gridFiles;
                for (GridFileType gridFileType : gridFiles = this.storageClient.listDirectory(this.decodedPath)) {
                    String childPath = gridFileType.getPath();
                    if (childPath.startsWith("/")) {
                        childPath = childPath.substring(1);
                    }
                    File file = (File)this.storage.getLocation().getChildLocation("files").getChildLocation(this.encode(childPath)).locate(new Object[]{this.storage.getStorageClient(), gridFileType});
                    children.add(file);
                }
                return children;
            }
            catch (BaseFault e) {
                throw new HiLAException("Cannot list directory", (Throwable)e);
            }
        }
        return Collections.singletonList(this);
    }

    public boolean mkdir(boolean _createParents) throws HiLAException {
        if (_createParents) {
            try {
                this.storageClient.createDirectory(this.decodedPath);
                return this.exists();
            }
            catch (BaseFault e) {
                return false;
            }
        }
        File parent = (File)this.getParent();
        if (parent.exists() && parent.isDirectory()) {
            try {
                this.storageClient.createDirectory(this.decodedPath);
                return this.exists();
            }
            catch (BaseFault e) {
                return false;
            }
        }
        return false;
    }

    private String encode(String _original) {
        _original = _original.replace("#", "%23");
        _original = _original.replace("%", "%25");
        return _original.replace(" ", "%20");
    }

    private String decode(String _original) {
        _original = _original.replace("%23", "#");
        _original = _original.replace("%25", "%");
        return _original.replace("%20", " ");
    }

    public boolean isExecutable() throws HiLAException {
        this.updateGridFile();
        return this.gridFile.getPermissions().getExecutable();
    }

    public boolean isReadable() throws HiLAException {
        this.updateGridFile();
        return this.gridFile.getPermissions().getReadable();
    }

    public boolean isWritable() throws HiLAException {
        this.updateGridFile();
        return this.gridFile.getPermissions().getWritable();
    }

    public void setIsExecutable(boolean executable) throws HiLAException {
        this.updateGridFile();
        try {
            PermissionsType perms = this.gridFile.getPermissions();
            perms.setExecutable(executable);
            this.storageClient.changePermissions(this.decodedPath, perms.getReadable(), perms.getWritable(), perms.getExecutable());
        }
        catch (BaseFault e) {
            throw new HiLAException("Unable to change executable permission", (Throwable)e);
        }
    }

    public void setIsReadable(boolean readable) throws HiLAException {
        this.updateGridFile();
        try {
            PermissionsType perms = this.gridFile.getPermissions();
            perms.setReadable(readable);
            this.storageClient.changePermissions(this.decodedPath, perms.getReadable(), perms.getWritable(), perms.getExecutable());
        }
        catch (BaseFault e) {
            throw new HiLAException("Unable to change readable permission", (Throwable)e);
        }
    }

    public void setIsWritable(boolean writable) throws HiLAException {
        this.updateGridFile();
        try {
            PermissionsType perms = this.gridFile.getPermissions();
            perms.setWritable(writable);
            this.storageClient.changePermissions(this.decodedPath, perms.getReadable(), perms.getWritable(), perms.getExecutable());
        }
        catch (BaseFault e) {
            throw new HiLAException("Unable to change executable permission", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyTo(File other, boolean overwrite, boolean _recursive) throws HiLAException {
        if (this.storageClient == null) {
            if (this.storage == null) throw new HiLAException("No access to storage.");
            this.storageClient = this.storage.getStorageClient();
        }
        if (!(other instanceof Unicore6File)) {
            throw new HiLAException("Cannot copy to File of different type.");
        }
        Unicore6File u6other = (Unicore6File)other;
        if (!this.isDirectory()) {
            if (u6other.exists() && u6other.isDirectory()) {
                u6other = (Unicore6File)u6other.getChild(this.getName());
            } else if (u6other.exists() && !overwrite) {
                throw new HiLAException("File exists.");
            }
            if (!this.getStorage().equals(other.getStorage())) throw new HiLAException("It is only possible to copy files within a storage. Use transfer for different storages");
            try {
                this.storageClient.copy(this.decodedPath, u6other.decodedPath);
                return;
            }
            catch (BaseFault e) {
                throw new HiLAException("Unable to copy File within storage.", (Throwable)e);
            }
        } else {
            if (!_recursive) {
                throw new HiLAException("Missing 'recursive' option to copy directory structures.");
            }
            if (u6other.exists() && u6other.isDirectory()) {
                u6other = (Unicore6File)u6other.getChild(this.getName());
                if (this.isDirectory() && !u6other.exists()) {
                    u6other.mkdir();
                }
            } else {
                if (u6other.exists() && !u6other.isDirectory()) {
                    throw new HiLAException("Cannot copy directory structure into a single file.");
                }
                u6other.mkdir();
            }
            List<File> children = this.ls();
            for (File file : children) {
                file.copyTo((File)((Unicore6File)u6other.getChild(file.getName())), overwrite, _recursive);
            }
        }
    }

    public Date lastModified() throws HiLAException {
        this.updateGridFile();
        return this.gridFile.getLastModified().getTime();
    }

    public void moveTo(File other, boolean overwrite) throws HiLAException {
        if (this.storageClient == null) {
            if (this.storage != null) {
                this.storageClient = this.storage.getStorageClient();
            } else {
                throw new HiLAException("No access to storage.");
            }
        }
        if (!(other instanceof Unicore6File)) {
            throw new HiLAException("Can only move files of the same type.");
        }
        Unicore6File u6other = (Unicore6File)other;
        if (u6other.exists() && u6other.isDirectory()) {
            u6other = (Unicore6File)u6other.getChild(this.getName());
        } else if (u6other.exists() && !overwrite) {
            throw new HiLAException("File exists.");
        }
        if (this.getStorage().equals(u6other.getStorage())) {
            try {
                this.storageClient.rename(this.decodedPath, u6other.decodedPath);
                this.gridFileTimeStamp = 0L;
            }
            catch (BaseFault e) {
                throw new HiLAException("Unable to move file within storage.", (Throwable)e);
            }
        } else {
            throw new HiLAException("Can only move files within the same storages");
        }
    }

    public ThirdPartyTransfer transfer(File _other, boolean _overwrite, boolean _recursive) throws HiLAException {
        if (_other instanceof Unicore6File) {
            if (_other.exists() && _other.isDirectory()) {
                _other = (File)_other.getChild(this.getName());
            }
            if (_other.exists() && !_overwrite) {
                throw new HiLAException("Won't overwrite existing file: " + _other.getLocation());
            }
            if (this.isDirectory()) {
                if (!_recursive) {
                    throw new HiLAException("Directories can only be copied recursively.");
                }
                Unicore6RecursiveTransferTask tpt = new Unicore6RecursiveTransferTask(this, (Unicore6File)_other);
                return tpt;
            }
            return new Unicore6TransferTask(this, this.storageClient, (Unicore6File)_other, ((Unicore6File)_other).storageClient);
        }
        throw new HiLAException("Can only transfer files of same type.");
    }

    private void updateGridFile() throws HiLAException {
        long ct = System.currentTimeMillis();
        if (this.gridFile == null || ct - this.gridFileTimeStamp > 500L) {
            if (this.storageClient == null) {
                if (this.storage != null) {
                    this.storageClient = this.storage.getStorageClient();
                } else {
                    throw new HiLAException("No access to storage.");
                }
            }
            try {
                this.gridFile = this.storageClient.listProperties(this.decodedPath);
                this.gridFileTimeStamp = System.currentTimeMillis();
            }
            catch (BaseFault e) {
                if (e.getMessage().contains(REASON_FILENOTFOUND)) {
                    throw new HiLAException("File not found.", (Throwable)e);
                }
                throw new HiLAException("Unable to update file properties.", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new HiLAException("File does not exist.", (Throwable)e);
            }
        }
    }

    public String getStagingURI() {
        return this.storageClient.getUrl().concat("#/").concat(this.getPath());
    }

    public SimpleTransfer exportToStream(OutputStream _os) throws HiLAException {
        Location storageLocation = Unicore6File.findParentLocationOfType(Storage.class, (Location)this.location, Grid.class);
        return new Unicore6ExportToStreamTask(storageLocation, this.storageClient, this.decodedPath, this, _os);
    }

    public SimpleTransfer importFromStream(InputStream is, boolean overwrite) throws HiLAException {
        if (this.exists() && !overwrite) {
            throw new HiLAException("Existing remote file will not be overwritten.");
        }
        Unicore6ImportFromStreamTask trsf = new Unicore6ImportFromStreamTask(this.location, this.storageClient, this.decodedPath, is);
        return trsf;
    }
}

