/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseSimpleTransfer;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.exceptions.HiLAResourceNotFoundException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.grid.unicore6.Unicore6ExportsCollection;
import eu.unicore.hila.grid.unicore6.util.FileTransfers;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;

@ResourceType(locationStructure={"unicore6:/sites/{site}/storages/{storage}/exports/{export}/?", "unicore6:/{user}@sites/{site}/storages/{storage}/exports/{export}/?", "unicore6:/sites/{site}/tasks/{task}/wd/exports/{export}", "unicore6:/{user}@sites/{site}/tasks/{task}/wd/exports/{export}", "unicore6:/storages/{storage}/exports/{export}", "unicore6:/{user}@storages/{storage}/exports/{export}"})
public class Unicore6ExportTask
extends BaseSimpleTransfer
implements SimpleTransfer,
Callable<TaskStatus> {
    private StorageClient storageClient;
    private String path;
    private File remoteFile;
    private java.io.File localFile;
    private boolean overwrite;
    private FileTransferClient exportClient;
    private long maxBytes;
    private long currentBytes;

    public Unicore6ExportTask(Location _storageLocation, StorageClient _storageClient, String _path, File _remoteFile, java.io.File _localFile, boolean _overWrite) throws HiLAException {
        super(_storageLocation.getChildLocation("exports").getChildLocation(UUID.randomUUID().toString()));
        this.storageClient = _storageClient;
        this.path = _path;
        this.remoteFile = _remoteFile;
        this.localFile = _localFile;
        this.overwrite = _overWrite;
        this.setCurrentState(TaskStatus.PENDING);
        HiLA.getExecutor().submit(this);
        Unicore6ExportsCollection ec = (Unicore6ExportsCollection)this.getParent();
        if (ec != null) {
            ec.addTask(this);
        }
    }

    protected Unicore6ExportTask(Location _location) {
        super(_location);
    }

    public static synchronized Unicore6ExportTask locate(Location _location, Object ... _extraInformation) throws HiLAException {
        Resource exportsRes = _location.getParentLocation().locate(new Object[0]);
        List exports = exportsRes.getChildren();
        for (Resource resource : exports) {
            if (!resource.getLocation().equals((Object)_location)) continue;
            return (Unicore6ExportTask)resource;
        }
        throw new HiLAResourceNotFoundException("This export does not exist: " + _location);
    }

    @Override
    public TaskStatus call() throws Exception {
        block16: {
            this.setCurrentState(TaskStatus.RUNNING);
            if (this.storageClient != null) {
                OutputStream fos = null;
                try {
                    if (!this.remoteFile.exists()) {
                        HiLAException e = new HiLAException("No such file or directory.");
                        this.setCurrentState(TaskStatus.FAILED, e);
                        throw e;
                    }
                    HashMap<String, String> extraParameters = new HashMap<String, String>();
                    FileTransfers.getDefaultUftpParameters(extraParameters);
                    this.exportClient = this.storageClient.getExport(this.path, extraParameters, FileTransfers.getFTPrefs());
                    if (this.overwrite || !this.localFile.exists()) {
                        fos = new FileOutputStream(this.localFile);
                        this.exportClient.readAllData(fos);
                        fos.close();
                        break block16;
                    }
                    HiLAException e = new HiLAException("File exists, but may not be overwritten.");
                    this.setCurrentState(TaskStatus.FAILED, e);
                    this.exportClient.destroy();
                    this.exportClient = null;
                    throw e;
                }
                catch (IOException e) {
                    HiLAException e2 = new HiLAException("Unable to export to local file.", (Throwable)e);
                    this.setCurrentState(TaskStatus.FAILED, e2);
                    if (this.exportClient != null) {
                        this.exportClient.destroy();
                        this.exportClient = null;
                    }
                    throw e2;
                }
                catch (Exception e) {
                    HiLAException e2 = new HiLAException("Exception while reading data from remote file.", (Throwable)e);
                    this.setCurrentState(TaskStatus.FAILED, e2);
                    if (this.exportClient != null) {
                        this.exportClient.destroy();
                        this.exportClient = null;
                    }
                    throw e2;
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        this.setCurrentState(TaskStatus.SUCCESSFUL);
        this.exportClient.destroy();
        this.exportClient = null;
        return this.status();
    }

    public synchronized void abort() throws HiLAException {
        try {
            if (this.exportClient != null) {
                this.exportClient.destroy();
                this.exportClient = null;
            }
        }
        catch (BaseFault e) {
            throw new HiLAException(e.getMessage(), (Throwable)e);
        }
        catch (ResourceUnavailableFault e) {
            throw new HiLAException(e.getMessage(), (Throwable)e);
        }
        catch (ResourceUnknownFault e) {
            throw new HiLAException(e.getMessage(), (Throwable)e);
        }
        catch (ResourceNotDestroyedFault e) {
            throw new HiLAException(e.getMessage(), (Throwable)e);
        }
        catch (ClientException e) {
            throw new HiLAException(e.getMessage(), (Throwable)e);
        }
    }

    public String getId() {
        return this.location.getName();
    }

    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> children = new ArrayList<Resource>();
        return children;
    }

    @Override
    public String getUnit() throws HiLANotImplementedException {
        return "bytes";
    }

    @Override
    public synchronized long getMax() throws HiLAException {
        if (this.exportClient != null) {
            this.maxBytes = this.exportClient.getSourceFileSize();
        }
        return this.maxBytes;
    }

    @Override
    public synchronized long getCurrent() throws HiLAException {
        if (this.exportClient != null) {
            try {
                this.currentBytes = this.exportClient.getTransferredBytes();
            }
            catch (Exception e) {
                throw new HiLAException("Unable to determine current transfer status.", (Throwable)e);
            }
        }
        return this.currentBytes;
    }
}

