/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Config;
import eu.unicore.hila.grid.Submittable;
import eu.unicore.hila.grid.unicore6.GetOrchestratorFromEPR;
import eu.unicore.hila.grid.unicore6.GetServicesFromRegistry;
import eu.unicore.hila.grid.unicore6.Unicore6Properties;
import eu.unicore.hila.grid.unicore6.Unicore6SecurityProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.chemomentum.common.ws.IServiceOrchestrator;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ServiceOrchestratorLocator {
    private static final Logger log = Logger.getLogger(ServiceOrchestratorLocator.class);
    private static volatile ServiceOrchestratorLocator theInstance;
    private static Object theInstanceLock;
    private volatile Config config;
    private Object configLock = new Object();

    private ServiceOrchestratorLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceOrchestratorLocator getInstance() {
        if (theInstance == null) {
            Object object = theInstanceLock;
            synchronized (object) {
                if (theInstance == null) {
                    theInstance = new ServiceOrchestratorLocator();
                }
            }
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Submittable> getAllOrchestrators(List<String> _registryURLs, Unicore6Properties _props, long timeoutMillis, Location _parentLocation) throws HiLAException {
        IClientConfiguration secProps;
        if (this.config == null) {
            Object object = this.configLock;
            synchronized (object) {
                if (this.config == null) {
                    Constructor<?> constructor;
                    Class<?> configClass;
                    String configProviderClass = _props.getConfigImplementation();
                    try {
                        configClass = Class.forName(configProviderClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new HiLAException("hila.unicore6.config references unknown class" + configProviderClass, (Throwable)e);
                    }
                    catch (ClassCastException e) {
                        throw new HiLAException(configProviderClass + " is not a subclass of " + Config.class.getName());
                    }
                    try {
                        constructor = configClass.getConstructor(Unicore6Properties.class);
                    }
                    catch (SecurityException e) {
                        throw new HiLAException(e.getMessage(), (Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new HiLAException("Config implementation referenced in hila.unicore6.config does not provide the correct constructor", (Throwable)e);
                    }
                    try {
                        this.config = (Config)constructor.newInstance(_props);
                    }
                    catch (IllegalArgumentException e) {
                        throw new HiLAException(e.getMessage(), (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        throw new HiLAException(e.getMessage(), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new HiLAException(e.getMessage(), (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new HiLAException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if ((secProps = (Unicore6SecurityProperties)this.config.getIdForLocation(_parentLocation)) != null) {
            secProps = secProps.clone();
        }
        ArrayList<Submittable> orchestrators = new ArrayList<Submittable>();
        ExecutorService executor = HiLA.getExecutor();
        ArrayList<Future<List<EndpointReferenceType>>> orchEPRFutures = new ArrayList<Future<List<EndpointReferenceType>>>();
        for (String registryURL : _registryURLs) {
            GetServicesFromRegistry getSvcOrchs = new GetServicesFromRegistry(registryURL, secProps, IServiceOrchestrator.PORT);
            orchEPRFutures.add(executor.submit(getSvcOrchs));
        }
        long registryDeadline = System.currentTimeMillis() + timeoutMillis;
        for (Future future : orchEPRFutures) {
            try {
                List orchEPRs = (List)future.get(registryDeadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                ArrayList<Future<Submittable>> orchFutures = new ArrayList<Future<Submittable>>();
                for (EndpointReferenceType oEPR : orchEPRs) {
                    IClientConfiguration sp = secProps.clone();
                    sp.getETDSettings().setExtendTrustDelegation(true);
                    GetOrchestratorFromEPR getOrchestratorFromEPR = new GetOrchestratorFromEPR(oEPR, sp, _parentLocation);
                    orchFutures.add(executor.submit(getOrchestratorFromEPR));
                }
                long svcOrchDeadline = System.currentTimeMillis() + timeoutMillis;
                for (Future future2 : orchFutures) {
                    try {
                        orchestrators.add((Submittable)future2.get(svcOrchDeadline, TimeUnit.MILLISECONDS));
                    }
                    catch (InterruptedException e) {
                        log.error("Interrupted while waiting for service orchestrator.", e);
                    }
                    catch (ExecutionException e) {
                        log.error("Error retrieving service orchestrator.", e);
                    }
                    catch (TimeoutException e) {
                        log.error("Timeout while waiting for service orchestrator.", e);
                    }
                }
            }
            catch (InterruptedException e) {
                log.error("Interrupted while waiting for registry.", e);
            }
            catch (ExecutionException e) {
                log.error("Error retrieving storage references.", e);
            }
            catch (TimeoutException e) {
                log.error("Timeout waiting for registry.", e);
            }
        }
        return orchestrators;
    }

    static {
        theInstanceLock = new Object();
    }
}

