/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.common.grid;

import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.grid.History;
import eu.unicore.hila.grid.Progressable;
import eu.unicore.hila.grid.StatusChangeListener;
import eu.unicore.hila.grid.StatusChangedEvent;
import eu.unicore.hila.grid.Task;
import eu.unicore.hila.grid.TaskStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class BaseTask
extends BaseResource
implements Task,
Progressable {
    private static final Logger log = Logger.getLogger(BaseTask.class);
    private TaskStatus currentState = null;
    private List<StatusChangeListener> statusListeners = new ArrayList<StatusChangeListener>();
    private ScheduledFuture<?> monitorFuture;
    protected HiLAException error = null;

    public BaseTask(Location location) {
        super(location);
    }

    public HiLAException getError() {
        HiLAException error = this.error;
        this.error = null;
        return error;
    }

    protected boolean isFinalState(TaskStatus _status) {
        if (_status == null) {
            return false;
        }
        return _status.equals((Object)TaskStatus.ABORTED) || _status.equals((Object)TaskStatus.FAILED) || _status.equals((Object)TaskStatus.SUCCESSFUL);
    }

    public void registerStatusChangeListener(StatusChangeListener _listener) {
        this.statusListeners.add(_listener);
        if (this.statusListeners.size() == 1) {
            this.startPeriodicMonitoring();
        }
    }

    private void startPeriodicMonitoring() {
        if (log.isDebugEnabled()) {
            log.debug("Starting periodic monitoring of Task " + this.location);
        }
        this.monitorFuture = HiLA.getDaemonExecutor().scheduleWithFixedDelay(new StatusMonitor(this), 0L, 1L, TimeUnit.SECONDS);
    }

    public void removeStatusChangeListener(StatusChangeListener _listener) {
        this.statusListeners.remove(_listener);
        if (this.statusListeners.size() == 0) {
            this.stopPeriodicMonitoring();
        }
    }

    private void stopPeriodicMonitoring() {
        if (log.isDebugEnabled()) {
            log.debug("Stopping periodic monitoring of Task " + this.location);
        }
        this.monitorFuture.cancel(false);
    }

    public TaskStatus block() throws HiLAException {
        while (!this.isDone()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.status();
    }

    public TaskStatus status() throws HiLAException {
        return this.currentState;
    }

    public History getHistory() throws HiLAException {
        throw new HiLANotImplementedException("History not implemented.");
    }

    public boolean isDone() throws HiLAException {
        return this.status().isFinalState();
    }

    public TaskStatus block(long arg0) throws HiLAException {
        long deadline = System.currentTimeMillis() + arg0;
        while (!this.isDone() && deadline > System.currentTimeMillis()) {
            try {
                Thread.sleep(Math.min(1000L, deadline - System.currentTimeMillis()));
            }
            catch (InterruptedException e) {}
        }
        return this.status();
    }

    public String getUnit() throws HiLANotImplementedException {
        throw new HiLANotImplementedException("Empty Progressage.getUnit() implementation.");
    }

    public void notifyListeners(Task _task, TaskStatus _status) {
        for (StatusChangeListener listener : this.statusListeners) {
            listener.statusChanged(new StatusChangedEvent(_task, _status));
        }
    }

    public long getCurrent() throws HiLAException {
        throw new HiLANotImplementedException("Empty Progressable.getCurrent() implementation.");
    }

    public long getMax() throws HiLAException {
        throw new HiLANotImplementedException("Empty Progressable.getMax() implementation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentState(TaskStatus _status, HiLAException e) {
        if (e != null) {
            this.error = e;
        }
        this.currentState = _status;
        BaseTask baseTask = this;
        synchronized (baseTask) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    protected void setCurrentState(TaskStatus _status) {
        this.setCurrentState(_status, null);
    }

    private class StatusMonitor
    implements Runnable {
        Task task;

        public StatusMonitor(Task _task) {
            this.task = _task;
        }

        @Override
        public void run() {
            try {
                TaskStatus oldStatus = BaseTask.this.currentState;
                BaseTask.this.status();
                if (oldStatus != BaseTask.this.currentState) {
                    BaseTask.this.notifyListeners(this.task, BaseTask.this.currentState);
                }
            }
            catch (HiLAException e) {
                log.error("Monitoring of job failed", e);
            }
        }
    }
}

