/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.Task;
import de.fzj.unicore.uas.client.BaseUASClient;
import eu.unicore.unicore6.task.CancelRequestDocument;
import eu.unicore.unicore6.task.ResultDocument;
import eu.unicore.unicore6.task.SubmissionTimeDocument;
import eu.unicore.unicore6.task.TaskPropertiesDocument;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.math.BigInteger;
import java.util.Calendar;
import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.StatusInfoType;
import org.unigrids.services.atomic.types.StatusType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TaskClient
extends BaseUASClient {
    private Calendar submissionTime;
    private Integer exitCode;

    public TaskClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
    }

    public TaskClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public TaskPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return TaskPropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public XmlObject getResult() throws Exception {
        ResultDocument.Result result = this.getResourcePropertiesDocument().getTaskProperties().getResult();
        if (result == null) {
            return null;
        }
        return XmlObject.Factory.parse(result.newXMLStreamReader());
    }

    public StatusType.Enum getStatus() throws Exception {
        StatusInfoType s = this.getResourcePropertiesDocument().getTaskProperties().getStatusInfo();
        return s.getStatus();
    }

    public Integer getExitCode() throws Exception {
        BigInteger eCode;
        StatusInfoType sit;
        if (this.exitCode == null && (sit = this.getResourcePropertiesDocument().getTaskProperties().getStatusInfo()).isSetExitCode() && (eCode = sit.getExitCode()) != null) {
            this.exitCode = eCode.intValue();
        }
        return this.exitCode;
    }

    public Float getProgress() throws Exception {
        if (this.getResourcePropertiesDocument().getTaskProperties().getStatusInfo().isSetProgress()) {
            return Float.valueOf(this.getResourcePropertiesDocument().getTaskProperties().getStatusInfo().getProgress());
        }
        return null;
    }

    public Calendar getSubmissionTime() throws Exception {
        if (this.submissionTime == null) {
            this.submissionTime = SubmissionTimeDocument.Factory.parse(this.getResourceProperty(Task.RP_SUBMISSION_TIME)).getSubmissionTime();
        }
        return this.submissionTime;
    }

    public String getStatusMessage() throws Exception {
        return this.getResourcePropertiesDocument().getTaskProperties().getStatusInfo().getDescription();
    }

    public void cancel() throws Exception {
        CancelRequestDocument c = CancelRequestDocument.Factory.newInstance();
        c.addNewCancelRequest();
        this.makeProxy(Task.class).Cancel(c);
    }
}

