/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.local;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Session;
import org.codehaus.xfire.transport.local.LocalTransport;
import org.codehaus.xfire.util.STAXUtils;

public class LocalChannel
extends AbstractChannel {
    private static final Log logger = LogFactory.getLog(LocalChannel.class);
    protected static final String SENDER_URI = "senderUri";
    protected static final String OLD_CONTEXT = "urn:xfire:transport:local:oldContext";
    private final Session session;

    public LocalChannel(String uri, LocalTransport transport, Session session) {
        this.session = session;
        this.setUri(uri);
        this.setTransport(transport);
    }

    public void open() {
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        if (message.getUri().equals("urn:xfire:channel:backchannel")) {
            OutputStream out = (OutputStream)context.getProperty("urn:xfire:channel:backchannel");
            if (out != null) {
                XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(out, message.getEncoding(), context);
                message.setProperty("channel.outputstream", out);
                message.getSerializer().writeMessage(message, writer, context);
                try {
                    writer.close();
                }
                catch (XMLStreamException e) {
                    throw new XFireException("Couldn't close stream.", e);
                }
            } else {
                MessageContext oldContext = (MessageContext)context.getProperty(OLD_CONTEXT);
                Channel channel = oldContext.getOutMessage().getChannel();
                this.sendViaNewChannel(context, oldContext, message, channel, (String)context.getProperty(SENDER_URI));
            }
        } else {
            Channel channel;
            MessageContext receivingContext = new MessageContext();
            receivingContext.setXFire(context.getXFire());
            receivingContext.setService(this.getService(context.getXFire(), message.getUri()));
            receivingContext.setProperty(OLD_CONTEXT, context);
            receivingContext.setProperty(SENDER_URI, this.getUri());
            receivingContext.setSession(this.session);
            String uri = message.getUri();
            try {
                channel = this.getTransport().createChannel(uri);
            }
            catch (Exception e) {
                throw new XFireException("Couldn't create channel.", e);
            }
            this.sendViaNewChannel(context, receivingContext, message, channel, uri);
        }
    }

    protected Service getService(XFire xfire, String uri) throws XFireException {
        if (null == xfire) {
            return null;
        }
        int i = uri.indexOf("//");
        if (i == -1) {
            throw new XFireException("Malformed service URI");
        }
        String name = uri.substring(i + 2);
        Service service = xfire.getServiceRegistry().getService(name);
        if (null == service) {
            logger.info("Unable to locate '" + name + "' in ServiceRegistry");
        }
        return service;
    }

    private void sendViaNewChannel(final MessageContext context, MessageContext receivingContext, final OutMessage message, Channel channel, String uri) throws XFireException {
        try {
            PipedInputStream stream = new PipedInputStream();
            final PipedOutputStream outStream = new PipedOutputStream(stream);
            Thread writeThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(outStream, message.getEncoding(), context);
                        message.setProperty("channel.outputstream", outStream);
                        message.getSerializer().writeMessage(message, writer, context);
                        writer.close();
                        outStream.close();
                    }
                    catch (Exception e) {
                        throw new XFireRuntimeException("Couldn't write stream.", e);
                    }
                }
            });
            writeThread.start();
            try {
                XMLStreamReader reader = STAXUtils.createXMLStreamReader(stream, message.getEncoding(), context);
                InMessage inMessage = new InMessage(reader, uri);
                inMessage.setEncoding(message.getEncoding());
                channel.receive(receivingContext, inMessage);
                while (reader.hasNext()) {
                    reader.next();
                }
                reader.close();
                stream.close();
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Couldn't read stream.", e);
            }
            try {
                writeThread.join();
            }
            catch (InterruptedException e) {}
        }
        catch (IOException e) {
            throw new XFireRuntimeException("Couldn't create stream.", e);
        }
    }

    public void close() {
    }

    public boolean isAsync() {
        return true;
    }
}

