/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.attachments.Attachment;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.SimpleAttachment;

public class JavaMailAttachments
implements Attachments {
    private static final String[] filter = new String[]{"Message-ID", "Mime-Version", "Content-Type"};
    private Map parts = new HashMap();
    private Attachment soapMessage;
    private String soapContentType;
    private MimeMultipart mimeMP;

    public JavaMailAttachments() {
    }

    public JavaMailAttachments(InputStream is, String contentType) throws MessagingException, IOException {
        this();
        Session session = Session.getDefaultInstance(new Properties());
        MimeMessage inMsg = new MimeMessage(session, is);
        inMsg.addHeaderLine("Content-Type: " + contentType);
        Object content = inMsg.getContent();
        if (!(content instanceof MimeMultipart)) {
            throw new UnsupportedOperationException();
        }
        MimeMultipart inMP = (MimeMultipart)content;
        this.initMultipart(inMP);
    }

    public JavaMailAttachments(MimeMultipart multipart) throws MessagingException {
        this();
        this.initMultipart(multipart);
    }

    private void initMultipart(MimeMultipart multipart) throws MessagingException {
        this.mimeMP = multipart;
        MimeBodyPart part = (MimeBodyPart)multipart.getBodyPart(0);
        this.setSoapMessage(new SimpleAttachment(part.getContentID(), part.getDataHandler()));
        for (int i = 1; i < multipart.getCount(); ++i) {
            part = (MimeBodyPart)multipart.getBodyPart(i);
            String id = part.getContentID();
            if (id.startsWith("<")) {
                id = id.substring(1, id.length() - 1);
            }
            this.addPart(new SimpleAttachment(id, part.getDataHandler()));
        }
    }

    public Attachment getSoapMessage() {
        return this.soapMessage;
    }

    public void setSoapMessage(Attachment soapMessage) {
        this.soapMessage = soapMessage;
    }

    public void addPart(Attachment part) {
        this.parts.put(part.getId(), part);
    }

    public Iterator getParts() {
        return this.parts.values().iterator();
    }

    public Attachment getPart(String id) {
        return (Attachment)this.parts.get(id);
    }

    public int size() {
        return this.parts.size();
    }

    public void write(OutputStream out) throws IOException {
        Session session = Session.getDefaultInstance(new Properties(), null);
        MimeMessage message = new MimeMessage(session);
        try {
            MimeMultipart mimeMP = this.getMimeMultipart();
            MimeBodyPart soapPart = new MimeBodyPart();
            soapPart.setDataHandler(this.soapMessage.getDataHandler());
            soapPart.setContentID("<" + this.soapMessage.getId() + ">");
            soapPart.addHeader("Content-Transfer-Encoding", "8bit");
            mimeMP.addBodyPart(soapPart);
            Iterator itr = this.getParts();
            while (itr.hasNext()) {
                Attachment att = (Attachment)itr.next();
                MimeBodyPart part = new MimeBodyPart();
                part.setDataHandler(att.getDataHandler());
                part.setContentID("<" + att.getId() + ">");
                if (att.isXOP()) {
                    part.addHeader("Content-Transfer-Encoding", "binary");
                }
                mimeMP.addBodyPart(part);
            }
            message.setContent(mimeMP);
            message.writeTo(out, filter);
        }
        catch (MessagingException e) {
            throw new XFireRuntimeException("Couldn't create message.", e);
        }
    }

    public MimeMultipart getMimeMultipart() {
        if (this.mimeMP == null) {
            StringBuffer ct = new StringBuffer();
            ct.append("related; type=\"").append("application/xop+xml").append("\"; start=\"<").append(this.getSoapMessage().getId()).append(">\"; start-info=\"").append(this.getSoapContentType()).append("\"");
            this.mimeMP = new MimeMultipart(ct.toString());
        }
        return this.mimeMP;
    }

    public String getContentType() {
        return this.getMimeMultipart().getContentType();
    }

    public String getSoapContentType() {
        return this.soapContentType;
    }

    public void setSoapContentType(String soapContentType) {
        this.soapContentType = soapContentType;
    }

    public void dispose() {
    }
}

