/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.java5;

import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class EnumType
extends Type {
    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        String value = reader.getValue();
        return Enum.valueOf(this.getTypeClass(), value);
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        writer.writeValue(((Enum)object).toString());
    }

    public void setTypeClass(Class typeClass) {
        if (!typeClass.isEnum()) {
            throw new XFireRuntimeException("Type class must be an enum.");
        }
        super.setTypeClass(typeClass);
    }

    public void writeSchema(Element root) {
        T[] constants;
        Namespace xsd = Namespace.getNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        Element simple = new Element("simpleType", xsd);
        simple.setAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
        root.addContent(simple);
        Element restriction = new Element("restriction", xsd);
        restriction.setAttribute(new Attribute("base", "xsd:string"));
        simple.addContent(restriction);
        for (Object constant : constants = this.getTypeClass().getEnumConstants()) {
            Element enumeration = new Element("enumeration", xsd);
            enumeration.setAttribute(new Attribute("value", ((Enum)constant).toString()));
            restriction.addContent(enumeration);
        }
    }

    public boolean isComplex() {
        return true;
    }
}

