/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.Base64;
import org.jdom.Attribute;
import org.jdom.Element;
import org.w3c.dom.Document;

public class ObjectType
extends Type {
    private static final QName XSI_TYPE = new QName("http://www.w3.org/2001/XMLSchema-instance", "type");
    private static final QName XSI_NIL = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil");
    private Set dependencies;
    private boolean serializedWhenUnknown;
    private boolean readToDocument = false;

    public ObjectType() {
        this(Collections.EMPTY_SET);
        this.readToDocument = true;
    }

    public ObjectType(Set dependencies) {
        this(dependencies, false);
    }

    public ObjectType(boolean serializeWhenUnknown) {
        this(Collections.EMPTY_SET, serializeWhenUnknown);
    }

    public ObjectType(Set dependencies, boolean serializeWhenUnknown) {
        this.dependencies = dependencies;
        this.serializedWhenUnknown = serializeWhenUnknown;
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        if (this.isNil(reader.getAttributeReader(XSI_NIL))) {
            while (reader.hasMoreElementReaders()) {
                reader.getNextElementReader();
            }
            return null;
        }
        MessageReader typeReader = reader.getAttributeReader(XSI_TYPE);
        if (null == typeReader && !this.readToDocument) {
            throw new XFireFault("Missing 'xsi:type' attribute", XFireFault.SENDER);
        }
        String typeName = typeReader.getValue();
        if (null == typeName && !this.readToDocument) {
            throw new XFireFault("Missing 'xsi:type' attribute value", XFireFault.SENDER);
        }
        Type type = null;
        QName typeQName = null;
        typeQName = typeName != null ? this.extractQName(reader, typeName) : reader.getName();
        TypeMapping tm = (TypeMapping)context.getService().getProperty("type.mapping");
        if (tm == null) {
            tm = this.getTypeMapping();
        }
        if ((type = tm.getType(typeQName)) == null) {
            type = tm.getType(this.getSchemaType());
        }
        if (type == null && this.readToDocument) {
            type = this.getTypeMapping().getType(Document.class);
        }
        if (null == type) {
            if (this.serializedWhenUnknown && "serializedJavaObject".equals(typeName)) {
                return this.reconstituteJavaObject(reader);
            }
            throw new XFireFault("No mapped type for '" + typeName + "' (" + typeQName + ")", XFireFault.SENDER);
        }
        return type.readObject(reader, context);
    }

    private QName extractQName(MessageReader reader, String typeName) {
        int colon = typeName.indexOf(58);
        if (-1 == colon) {
            return new QName(reader.getNamespace(), typeName);
        }
        return new QName(reader.getNamespaceForPrefix(typeName.substring(0, colon)), typeName.substring(colon + 1));
    }

    private Object reconstituteJavaObject(MessageReader reader) throws XFireFault {
        ByteArrayInputStream in = new ByteArrayInputStream(Base64.decode(reader.getValue()));
        try {
            return new ObjectInputStream(in).readObject();
        }
        catch (Exception e) {
            throw new XFireFault("Unable to reconstitute serialized object", e, XFireFault.RECEIVER);
        }
    }

    private boolean isNil(MessageReader reader) {
        return null != reader && "true".equals(reader.getValue());
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        if (null == object) {
            MessageWriter nilWriter = writer.getAttributeWriter(XSI_NIL);
            nilWriter.writeValue("true");
            nilWriter.close();
        } else {
            String prefix;
            Type type = this.determineType(context, object.getClass());
            if (null == type) {
                TypeMapping tm = (TypeMapping)context.getService().getProperty("type.mapping");
                if (tm == null) {
                    tm = this.getTypeMapping();
                }
                type = tm.getTypeCreator().createType(object.getClass());
                tm.register(type);
            }
            if (null == (prefix = writer.getPrefixForNamespace(type.getSchemaType().getNamespaceURI())) || prefix.length() == 0) {
                this.addXsiType(writer, type.getSchemaType().getLocalPart());
            } else {
                this.addXsiType(writer, prefix + ":" + type.getSchemaType().getLocalPart());
            }
            type.writeObject(object, writer, context);
        }
    }

    private Type determineType(MessageContext context, Class clazz) {
        Type type;
        TypeMapping tm = (TypeMapping)context.getService().getProperty("type.mapping");
        if (tm == null) {
            tm = this.getTypeMapping();
        }
        if (null != (type = tm.getType(clazz))) {
            return type;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            type = tm.getType(anInterface);
            if (null == type) continue;
            return type;
        }
        Class superclass = clazz.getSuperclass();
        if (null == superclass || Object.class.equals(superclass)) {
            return null;
        }
        return this.determineType(context, superclass);
    }

    private void addXsiType(MessageWriter writer, String prefixedType) {
        MessageWriter typeWriter = writer.getAttributeWriter(XSI_TYPE);
        typeWriter.writeValue(prefixedType);
        typeWriter.close();
    }

    private void handleNullType(Object object, MessageWriter writer) throws XFireFault {
        if (!this.serializedWhenUnknown) {
            throw new XFireFault("Unable to write '" + object + "' [" + object.getClass().getName() + "]. Type is unknown.", XFireFault.RECEIVER);
        }
        this.addXsiType(writer, "serializedJavaObject");
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(out);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (IOException e) {
            throw new XFireFault("Unable to serialize '" + object + "' [" + object.getClass().getName() + "]", e, XFireFault.RECEIVER);
        }
        writer.writeValue(Base64.encode(out.toByteArray()));
    }

    public boolean isReadToDocument() {
        return this.readToDocument;
    }

    public void setReadToDocument(boolean readToDocument) {
        this.readToDocument = readToDocument;
    }

    public boolean isSerializedWhenUnknown() {
        return this.serializedWhenUnknown;
    }

    public void setSerializedWhenUnknown(boolean serializedWhenUnknown) {
        this.serializedWhenUnknown = serializedWhenUnknown;
    }

    public void setDependencies(Set dependencies) {
        this.dependencies = dependencies;
    }

    public Set getDependencies() {
        return this.dependencies;
    }

    public boolean isComplex() {
        return true;
    }

    public boolean isAbstract() {
        return super.isAbstract();
    }

    public boolean isNillable() {
        return super.isNillable();
    }

    public boolean isWriteOuter() {
        return super.isWriteOuter();
    }

    public void setNillable(boolean nillable) {
        super.setNillable(nillable);
    }

    public void writeSchema(Element root) {
        if (this.serializedWhenUnknown) {
            Element simple = new Element("simpleType", "xsd", "http://www.w3.org/2001/XMLSchema");
            simple.setAttribute(new Attribute("name", "serializedJavaObject"));
            root.addContent(simple);
            Element restriction = new Element("restriction", "xsd", "http://www.w3.org/2001/XMLSchema");
            restriction.setAttribute(new Attribute("base", "xsd:base64Binary"));
            simple.addContent(restriction);
        }
    }
}

