/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.util;

import java.net.URISyntaxException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class URIUtils {
    private URIUtils() {
    }

    public static String encodeAll(String uri) throws URISyntaxException {
        try {
            String result = URIUtils.encodeAuthority(uri);
            result = URIUtils.encodePath(uri);
            result = URIUtils.encodeQuery(result);
            result = URIUtils.encodeFragment(result);
            return result;
        }
        catch (URIException e) {
            throw new URISyntaxException(uri, "Could not encode");
        }
    }

    private static String encodeAuthority(String uri) throws URIException {
        int end;
        int start = uri.indexOf("//");
        if (start == -1) {
            return uri;
        }
        if ((end = uri.indexOf("/", ++start + 1)) == -1) {
            end = uri.indexOf("?", start + 1);
        }
        if (end == -1) {
            end = uri.indexOf("#", start + 1);
        }
        if (end == -1) {
            end = uri.length();
        }
        String before = uri.substring(0, start + 1);
        String authority = uri.substring(start + 1, end);
        String after = uri.substring(end);
        authority = URIUtil.encode(authority, URI.allowed_authority);
        return String.valueOf(before) + authority + after;
    }

    private static String encodePath(String uri) throws URIException {
        int doubleSlashIndex = uri.indexOf("//");
        boolean hasAuthority = doubleSlashIndex >= 0;
        int start = -1;
        start = hasAuthority ? uri.indexOf("/", doubleSlashIndex + 2) : uri.indexOf(":");
        if (start == -1) {
            return uri;
        }
        int end = uri.indexOf("?", start + 1);
        if (end == -1) {
            end = uri.indexOf("#", start + 1);
        }
        if (end == -1) {
            end = uri.length();
        }
        String before = uri.substring(0, start + 1);
        String path = uri.substring(start + 1, end);
        String after = uri.substring(end);
        path = URIUtil.encode(path, URI.allowed_abs_path);
        return String.valueOf(before) + path + after;
    }

    private static String encodeQuery(String uri) throws URIException {
        int queryStart = uri.indexOf("?");
        if (queryStart == -1) {
            return uri;
        }
        int queryEnd = uri.indexOf("#");
        if (queryEnd == -1) {
            queryEnd = uri.length();
        }
        String beforeQuery = uri.substring(0, queryStart + 1);
        String query = uri.substring(queryStart + 1, queryEnd);
        String afterQuery = uri.substring(queryEnd);
        query = URIUtil.encode(query, URI.allowed_query);
        return String.valueOf(beforeQuery) + query + afterQuery;
    }

    private static String encodeFragment(String uri) throws URIException {
        int fragmentStart = uri.indexOf("#");
        if (fragmentStart == -1) {
            return uri;
        }
        String beforeFragment = uri.substring(0, fragmentStart + 1);
        String fragment = uri.substring(fragmentStart + 1);
        fragment = URIUtil.encode(fragment, URI.allowed_fragment);
        return String.valueOf(beforeFragment) + fragment;
    }
}

