/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.impl.gris;

import eu.unicore.security.util.client.IClientProperties;
import eu.unicore.security.xfireutil.client.SecuredXFireClientFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.chemomentum.common.ws.IGridResourceInfoUpload;
import org.chemomentum.gris.xmlbeans.AddResourceRequestDocument;
import org.chemomentum.gris.xmlbeans.ReportAttributeResultType;
import org.chemomentum.gris.xmlbeans.ReportAttributeType;
import org.chemomentum.gris.xmlbeans.ReportAttributesRequestDocument;
import org.chemomentum.gris.xmlbeans.ReportAttributesResponseDocument;
import org.chemomentum.gris.xmlbeans.ResourceType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class GridResourceInfoUploadClient {
    protected String grisUrl;
    protected EndpointReferenceType grisEpr;
    IClientProperties secProperties;
    protected Logger logger = Logger.getLogger(GridResourceInfoUploadClient.class.getName());
    protected IGridResourceInfoUpload gris;

    public GridResourceInfoUploadClient(IGridResourceInfoUpload gris) {
        this.gris = gris;
    }

    public GridResourceInfoUploadClient(String url, EndpointReferenceType epr, IClientProperties sec) {
        this.grisUrl = url;
        this.grisEpr = epr;
        this.secProperties = sec;
    }

    public void addResources(ResourceType[] res) {
        AddResourceRequestDocument request = AddResourceRequestDocument.Factory.newInstance();
        request.addNewAddResourceRequest().setResourceArray(res);
        this.getGRIS().addResource(request);
    }

    public ReportAttributeResultType[] reportAttributes(ReportAttributeType[] atts) {
        ReportAttributesRequestDocument request = ReportAttributesRequestDocument.Factory.newInstance();
        request.addNewReportAttributesRequest().setAttributeArray(atts);
        ReportAttributesResponseDocument response = this.getGRIS().reportAttributes(request);
        ReportAttributeResultType[] results = response.getReportAttributesResponse().getResultArray();
        int i = 0;
        while (i < results.length) {
            if (results[i].getFailure() != null) {
                this.logger.log(Level.WARN, "An error occurred while reporting Attribute " + atts[i].xmlText() + ": " + results[i].getFailure().getErrorLog());
            }
            ++i;
        }
        return results;
    }

    protected IGridResourceInfoUpload getGRIS() {
        if (this.gris == null) {
            if (this.grisUrl == null || this.grisEpr == null) {
                this.logger.log(Level.WARN, "Could not invoke GRIS Service! No address for GRIS Service available!");
            } else {
                try {
                    return new SecuredXFireClientFactory().createPlainWSProxy(IGridResourceInfoUpload.class, this.grisUrl);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARN, "Could not invoke GRIS Service! ", e);
                }
            }
        }
        return this.gris;
    }
}

