/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;

public class ResolverDirectHTTP
extends ResourceResolverSpi {
    private static Log log = LogFactory.getLog(ResolverDirectHTTP.class);
    private static final String[] properties = new String[]{"http.proxy.host", "http.proxy.port", "http.proxy.username", "http.proxy.password", "http.basic.username", "http.basic.password"};
    private static final int HttpProxyHost = 0;
    private static final int HttpProxyPort = 1;
    private static final int HttpProxyUser = 2;
    private static final int HttpProxyPass = 3;
    private static final int HttpBasicUser = 4;
    private static final int HttpBasicPass = 5;

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr uri, String baseURI) throws ResourceResolverException {
        try {
            String auth;
            boolean useProxy = false;
            String proxyHost = this.engineGetProperty(properties[0]);
            String proxyPort = this.engineGetProperty(properties[1]);
            if (proxyHost != null && proxyPort != null) {
                useProxy = true;
            }
            String oldProxySet = null;
            String oldProxyHost = null;
            String oldProxyPort = null;
            if (useProxy) {
                if (log.isDebugEnabled()) {
                    log.debug("Use of HTTP proxy enabled: " + proxyHost + ":" + proxyPort);
                }
                oldProxySet = System.getProperty("http.proxySet");
                oldProxyHost = System.getProperty("http.proxyHost");
                oldProxyPort = System.getProperty("http.proxyPort");
                System.setProperty("http.proxySet", "true");
                System.setProperty("http.proxyHost", proxyHost);
                System.setProperty("http.proxyPort", proxyPort);
            }
            boolean switchBackProxy = oldProxySet != null && oldProxyHost != null && oldProxyPort != null;
            URI uriNew = null;
            try {
                uriNew = ResolverDirectHTTP.getNewURI(uri.getNodeValue(), baseURI);
            }
            catch (URISyntaxException ex) {
                throw new ResourceResolverException("generic.EmptyMessage", ex, uri, baseURI);
            }
            URL url = uriNew.toURL();
            URLConnection urlConnection = url.openConnection();
            String proxyUser = this.engineGetProperty(properties[2]);
            String proxyPass = this.engineGetProperty(properties[3]);
            if (proxyUser != null && proxyPass != null) {
                String password = proxyUser + ":" + proxyPass;
                String encodedPassword = Base64.encode(password.getBytes("ISO-8859-1"));
                urlConnection.setRequestProperty("Proxy-Authorization", encodedPassword);
            }
            if ((auth = urlConnection.getHeaderField("WWW-Authenticate")) != null && auth.startsWith("Basic")) {
                String user = this.engineGetProperty(properties[4]);
                String pass = this.engineGetProperty(properties[5]);
                if (user != null && pass != null) {
                    urlConnection = url.openConnection();
                    String password = user + ":" + pass;
                    String encodedPassword = Base64.encode(password.getBytes("ISO-8859-1"));
                    urlConnection.setRequestProperty("Authorization", "Basic " + encodedPassword);
                }
            }
            String mimeType = urlConnection.getHeaderField("Content-Type");
            InputStream inputStream = urlConnection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int read = 0;
            int summarized = 0;
            while ((read = inputStream.read(buf)) >= 0) {
                baos.write(buf, 0, read);
                summarized += read;
            }
            if (log.isDebugEnabled()) {
                log.debug("Fetched " + summarized + " bytes from URI " + uriNew.toString());
            }
            XMLSignatureInput result = new XMLSignatureInput(baos.toByteArray());
            result.setSourceURI(uriNew.toString());
            result.setMIMEType(mimeType);
            if (useProxy && switchBackProxy) {
                System.setProperty("http.proxySet", oldProxySet);
                System.setProperty("http.proxyHost", oldProxyHost);
                System.setProperty("http.proxyPort", oldProxyPort);
            }
            return result;
        }
        catch (MalformedURLException ex) {
            throw new ResourceResolverException("generic.EmptyMessage", ex, uri, baseURI);
        }
        catch (IOException ex) {
            throw new ResourceResolverException("generic.EmptyMessage", ex, uri, baseURI);
        }
    }

    public boolean engineCanResolve(Attr uri, String baseURI) {
        if (uri == null) {
            if (log.isDebugEnabled()) {
                log.debug("quick fail, uri == null");
            }
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        if (uriNodeValue.equals("") || uriNodeValue.charAt(0) == '#') {
            if (log.isDebugEnabled()) {
                log.debug("quick fail for empty URIs and local ones");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("I was asked whether I can resolve " + uriNodeValue);
        }
        if (uriNodeValue.startsWith("http:") || baseURI != null && baseURI.startsWith("http:")) {
            if (log.isDebugEnabled()) {
                log.debug("I state that I can resolve " + uriNodeValue);
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("I state that I can't resolve " + uriNodeValue);
        }
        return false;
    }

    public String[] engineGetPropertyKeys() {
        return (String[])properties.clone();
    }

    private static URI getNewURI(String uri, String baseURI) throws URISyntaxException {
        URI newUri = null;
        newUri = baseURI == null || "".equals(baseURI) ? new URI(uri) : new URI(baseURI).resolve(uri);
        if (newUri.getFragment() != null) {
            URI uriNewNoFrag = new URI(newUri.getScheme(), newUri.getSchemeSpecificPart(), null);
            return uriNewNoFrag;
        }
        return newUri;
    }
}

